/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.html.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.io.download.BufferingServletOutputStream;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.html.Utils;
import org.nuxeo.theme.themes.ThemeException;

public final class Images
extends HttpServlet
implements Serializable {
    private static final Log log = LogFactory.getLog(Images.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = request.getPathInfo().substring(1);
        byte[] data = null;
        try {
            data = Manager.getThemeManager().getImageResource(path);
        }
        catch (ThemeException e) {
            log.error((Object)("Image not found: " + path));
        }
        if (data != null) {
            ServletOutputStream os = response.getOutputStream();
            BufferingServletOutputStream.stopBuffering((OutputStream)os);
            String ext = FileUtils.getFileExtension((String)path);
            String mimeType = Utils.getImageMimeType(ext);
            response.addHeader("content-type", mimeType);
            String lifetime = "604800";
            long now = System.currentTimeMillis();
            response.addHeader("Cache-Control", "max-age=604800");
            response.addHeader("Cache-Control", "must-revalidate");
            response.setDateHeader("Last-Modified", now);
            response.setDateHeader("Expires", now + new Long("604800") * 1000L);
            os.write(data);
            os.close();
        }
    }
}

