/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.persistence.fs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.nuxeo.runtime.model.persistence.AbstractContribution;

public class ContributionLocation
extends AbstractContribution {
    protected final URL location;

    public ContributionLocation(String name, URL location) {
        super(name);
        this.location = location;
    }

    @Override
    public InputStream getStream() {
        try {
            return this.location.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot get '".concat(this.name).concat("' content"), e);
        }
    }

    @Override
    public String getContent() {
        try {
            return IOUtils.toString((InputStream)this.location.openStream(), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot get '".concat(this.name).concat("' content"), e);
        }
    }

    @Override
    public URL asURL() {
        return this.location;
    }
}

