/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.util;

import java.io.File;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.util.SimpleRuntime;

public abstract class NXRuntimeApplication {
    protected static RuntimeService runtime;
    private static final Log log;
    protected final File home;

    protected NXRuntimeApplication(File home) {
        this.home = home;
    }

    protected NXRuntimeApplication() {
        this(null);
    }

    public void start() {
        this.start(new String[0]);
    }

    public void start(String[] args) {
        try {
            this.initialize(args);
            this.run();
            this.shutdown();
        }
        catch (Throwable t) {
            log.error((Object)t);
            System.exit(1);
        }
    }

    public void initialize(String[] args) throws Exception {
        runtime = new SimpleRuntime(this.home);
        Framework.initialize(runtime);
        this.deployAll();
    }

    public void shutdown() throws Exception {
        Framework.shutdown();
    }

    public void deploy(String bundle) {
        URL url = this.getResource(bundle);
        if (url == null) {
            log.error((Object)("Cannot locate resource for deploying bundle " + bundle));
            return;
        }
        try {
            Framework.getRuntime().getContext().deploy(url);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void undeploy(String bundle) {
        URL url = this.getResource(bundle);
        assert (url != null);
        try {
            Framework.getRuntime().getContext().undeploy(url);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public URL getResource(String resource) {
        return runtime.getContext().getResource(resource);
    }

    protected void deployAll() {
        this.deploy("EventService.xml");
    }

    protected abstract void run() throws Exception;

    static {
        log = LogFactory.getLog(NXRuntimeApplication.class);
    }
}

