/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.service.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.service.proxy.MethodWrapper;

public abstract class MethodsWrapper
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(MethodsWrapper.class);
    protected Map<Method, Method> methods = new ConcurrentHashMap<Method, Method>();
    protected Class<?> wrapee;

    public MethodsWrapper(Class<?> klass) {
    }

    protected void loadMethods() {
        Method[] methods;
        this.methods = new ConcurrentHashMap<Method, Method>();
        for (Method method : methods = this.getClass().getMethods()) {
            if (method.getAnnotation(MethodWrapper.class) == null) continue;
            try {
                Method m = this.wrapee.getMethod(method.getName(), method.getParameterTypes());
                this.methods.put(m, method);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getWrappedMethod(Method method) {
        if (this.methods == null) {
            MethodsWrapper methodsWrapper = this;
            synchronized (methodsWrapper) {
                if (this.methods == null) {
                    this.loadMethods();
                }
            }
        }
        return this.methods.get(method);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method m = this.methods.get(method);
        if (m == null) {
            return method.invoke(proxy, args);
        }
        return method.invoke((Object)this, args);
    }
}

