/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.nuxeo.runtime.Version;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.ExtensionPoint;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.impl.ComponentManagerImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ComponentRegistrySerializer {
    private static final Log log = LogFactory.getLog(ComponentRegistrySerializer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeIndex(File file) throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            ComponentRegistrySerializer.writeIndex(writer);
        }
        finally {
            writer.close();
        }
    }

    public static void writeIndex(Writer writer) throws Exception {
        ComponentManagerImpl mgr = (ComponentManagerImpl)Framework.getRuntime().getComponentManager();
        for (RegistrationInfo ri : mgr.getRegistrations()) {
            ExtensionPoint[] xpoints;
            String bundle;
            ComponentName name = ri.getName();
            if (name == null) {
                log.error((Object)"BUG: Found component with null name");
                continue;
            }
            String src = ComponentRegistrySerializer.getComponentSrc(ri);
            if (src == null) {
                src = "";
            }
            if ((bundle = ri.getBundle()) == null) {
                bundle = ri.getContext().getBundle().getSymbolicName();
            }
            if (bundle == null) {
                bundle = "";
            }
            String cname = name.getName();
            writer.write("c:");
            writer.write(cname);
            writer.write(":");
            writer.write(bundle);
            writer.write(":");
            writer.write(src);
            writer.write("\n");
            String[] services = ri.getProvidedServiceNames();
            if (services != null && services.length > 0) {
                for (String service : services) {
                    writer.write("s:");
                    writer.write(cname);
                    writer.write(":");
                    writer.write(service);
                    writer.write("\n");
                }
            }
            if ((xpoints = ri.getExtensionPoints()) == null || xpoints.length <= 0) continue;
            for (ExtensionPoint xpoint : xpoints) {
                writer.write("x:");
                writer.write(cname);
                writer.write(":");
                writer.write(xpoint.getName());
                writer.write("\n");
            }
        }
    }

    private static String getComponentSrc(RegistrationInfo ri) {
        URL url = ri.getXmlFileUrl();
        if (url != null) {
            String src;
            String path = url.toExternalForm();
            int i = path.lastIndexOf(33);
            if (i > 0) {
                String jar = path.substring(0, i);
                path = path.substring(i + 1);
                int s = jar.lastIndexOf(47);
                if (s > -1) {
                    jar = jar.substring(s + 1);
                }
                src = jar + "!" + path;
            } else {
                int s = path.lastIndexOf(47);
                src = s != -1 ? path.substring(s + 1) : path;
            }
            return src;
        }
        return null;
    }

    public static Document toDocument() throws Exception {
        ComponentManagerImpl mgr = (ComponentManagerImpl)Framework.getRuntime().getComponentManager();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = factory.newDocumentBuilder().newDocument();
        Element root = doc.createElement("components");
        doc.appendChild(root);
        for (RegistrationInfo ri : mgr.getRegistrations()) {
            ExtensionPoint[] xps;
            String[] services;
            String docText;
            Version v;
            String bundle;
            ComponentName name = ri.getName();
            if (name == null) {
                log.error((Object)"BUG: Found component with null name");
                continue;
            }
            Element comp = doc.createElement("component");
            comp.setAttribute("name", name.getName());
            String impl = ri.getImplementation();
            if (impl != null && impl.length() > 0) {
                comp.setAttribute("class", impl);
            }
            if ((bundle = ri.getBundle()) == null) {
                bundle = ri.getContext().getBundle().getSymbolicName();
            }
            if (bundle != null) {
                comp.setAttribute("bundle", bundle);
            }
            if ((v = ri.getVersion()) != null) {
                comp.setAttribute("version", v.toString());
            }
            root.appendChild(comp);
            String src = ComponentRegistrySerializer.getComponentSrc(ri);
            if (src != null) {
                comp.setAttribute("src", src);
            }
            if ((docText = ri.getDocumentation()) != null) {
                docText = docText.trim();
                Element docu = doc.createElement("documentation");
                docu.setTextContent(docText);
                comp.appendChild(docu);
            }
            if ((services = ri.getProvidedServiceNames()) != null && services.length > 0) {
                Element svcsEl = doc.createElement("services");
                for (String service : services) {
                    Element svcEl = doc.createElement("service");
                    svcEl.setAttribute("class", service);
                    svcsEl.appendChild(svcEl);
                }
                comp.appendChild(svcsEl);
            }
            if ((xps = ri.getExtensionPoints()) == null || xps.length <= 0) continue;
            Element xpsEl = doc.createElement("extension-points");
            for (ExtensionPoint xp : xps) {
                Element xpEl = doc.createElement("extension-point");
                xpEl.setAttribute("name", xp.getName());
                docText = xp.getDocumentation();
                if (docText != null) {
                    xpEl.setTextContent(docText.trim());
                }
                xpsEl.appendChild(xpEl);
            }
            comp.appendChild(xpsEl);
        }
        return doc;
    }

    public static void toXML(OutputStream out) throws Exception {
        ComponentRegistrySerializer.toXML(out, "UTF-8");
    }

    public static void toXML(OutputStream out, String encoding) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter(out, encoding);
        ComponentRegistrySerializer.toXML(writer, encoding);
    }

    public static void toXML(Writer out) throws Exception {
        ComponentRegistrySerializer.toXML(out, "UTF-8");
    }

    public static void toXML(Writer out, String encoding) throws Exception {
        Document doc = ComponentRegistrySerializer.toDocument();
        OutputFormat format = new OutputFormat("xml", encoding, true);
        format.setIndent(2);
        XMLSerializer serializer = new XMLSerializer(out, format);
        serializer.serialize(doc);
        out.flush();
    }

    public static String toXML() throws Exception {
        StringWriter writer = new StringWriter();
        ComponentRegistrySerializer.toXML(writer);
        return writer.toString();
    }
}

