/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.runtime.service.AdaptableDescriptor;
import org.nuxeo.runtime.service.AdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdapterManager {
    private static final AdapterManager instance = new AdapterManager();
    protected final Map<Class<?>, AdaptableDescriptor> adapters = new ConcurrentHashMap();

    public static AdapterManager getInstance() {
        return instance;
    }

    public <T> T getAdapter(Object instance, Class<T> adapter) {
        AdapterFactory<?> af = this.getAdapterFactory(instance, adapter);
        if (af != null) {
            return adapter.cast(af.getAdapter(instance, adapter));
        }
        if (adapter.isInstance(instance)) {
            return (T)instance;
        }
        return null;
    }

    public AdapterFactory<?> getAdapterFactory(Object instance, Class<?> adapter) {
        return this.getAdapterFactory(instance.getClass(), adapter);
    }

    protected AdapterFactory<?> getAdapterFactory(Class<?> klass, Class<?> adapter) {
        AdapterFactory<?> factory;
        AdaptableDescriptor descriptor = this.adapters.get(klass);
        if (descriptor != null && (factory = descriptor.getAdapterFactory(adapter)) != null) {
            return factory;
        }
        return this.findAdapterFactory(klass, adapter);
    }

    protected synchronized AdapterFactory<?> findAdapterFactory(Class<?> klass, Class<?> adapter) {
        Class<?>[] superTypes;
        AdaptableDescriptor descriptor = this.adapters.get(klass);
        if (descriptor != null) {
            AdapterFactory<?> factory = descriptor.getAdapterFactory(adapter);
            if (factory != null) {
                return factory;
            }
        } else {
            descriptor = new AdaptableDescriptor(klass);
            this.adapters.put(klass, descriptor);
        }
        for (Class<?> superType : superTypes = descriptor.getSuperTypes()) {
            AdapterFactory<?> factory = this.findAdapterFactory(superType, adapter);
            if (factory == null) continue;
            descriptor.addAdapterFactory(adapter, factory);
            return factory;
        }
        return null;
    }

    public synchronized void registerAdapter(AdapterFactory<?> factory) {
        Class<?> adaptable = factory.getAdaptableType();
        AdaptableDescriptor descriptor = this.adapters.get(adaptable);
        if (descriptor == null) {
            descriptor = new AdaptableDescriptor(adaptable);
            this.adapters.put(adaptable, descriptor);
        }
        for (Class<?> klass : factory.getAdapterTypes()) {
            descriptor.addAdapterFactory(klass, factory);
        }
    }

    public void unregisterAdapter(Class<?> adapter) {
    }
}

