/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.osgi;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.osgi.OSGiComponentLoader;
import org.nuxeo.runtime.osgi.OSGiRuntimeService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class OSGiRuntimeActivator
implements BundleActivator {
    private static final Log log = LogFactory.getLog(OSGiRuntimeActivator.class);
    protected OSGiRuntimeService runtime;
    protected OSGiComponentLoader componentLoader;

    public void start(BundleContext context) throws Exception {
        log.info((Object)"Starting Runtime Activator");
        this.runtime = new OSGiRuntimeService(context);
        URL config = context.getBundle().getResource("/OSGI-INF/nuxeo.properties");
        if (config != null) {
            System.setProperty("CONFIG_DIR", config.toExternalForm());
        }
        this.initialize(this.runtime);
        Framework.initialize(this.runtime);
        this.componentLoader = new OSGiComponentLoader(this.runtime);
    }

    public void stop(BundleContext context) throws Exception {
        log.info((Object)"Stopping Runtime Activator");
        this.componentLoader.uninstall();
        this.componentLoader = null;
        Framework.shutdown();
        this.uninitialize(this.runtime);
        this.runtime = null;
    }

    protected void initialize(OSGiRuntimeService runtime) {
    }

    protected void uninitialize(OSGiRuntimeService runtime) {
    }
}

