/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.runners.model.FrameworkMethod;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class MethodSorter {
    private MethodSorter() {
    }

    public static void sortMethodsUsingSourceOrder(List<FrameworkMethod> methods) {
        if (methods.isEmpty()) {
            return;
        }
        HashMap<String, Integer> nameToLine = new HashMap<String, Integer>();
        Class<?> cls = methods.get(0).getMethod().getDeclaringClass();
        String name = "/" + cls.getName().replace(".", "/") + ".class";
        try (InputStream is = cls.getResourceAsStream(name);){
            ClassReader cr = new ClassReader(is);
            CV cv = new CV(nameToLine);
            cr.accept((ClassVisitor)cv, 4);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse " + name, e);
        }
        Collections.sort(methods, new LineComparator(nameToLine));
    }

    public static class LineComparator
    implements Comparator<FrameworkMethod> {
        public Map<String, Integer> nameToLine;

        public LineComparator(Map<String, Integer> nameToLine) {
            this.nameToLine = nameToLine;
        }

        @Override
        public int compare(FrameworkMethod fm1, FrameworkMethod fm2) {
            String name1 = fm1.getMethod().getName();
            String name2 = fm2.getMethod().getName();
            Integer pos1 = this.nameToLine.get(name1);
            Integer pos2 = this.nameToLine.get(name2);
            if (pos1 == null || pos2 == null) {
                return name1.compareTo(name2);
            }
            return pos1.compareTo(pos2);
        }
    }

    public static class MV
    extends MethodVisitor {
        public Map<String, Integer> nameToLine;
        public final String name;

        public MV(Map<String, Integer> nameToLine, String name) {
            super(327680);
            this.nameToLine = nameToLine;
            this.name = name;
        }

        public void visitLineNumber(int line, Label start) {
            if (this.nameToLine.get(this.name) == null) {
                this.nameToLine.put(this.name, line);
            }
        }
    }

    public static class CV
    extends ClassVisitor {
        public Map<String, Integer> nameToLine;

        public CV(Map<String, Integer> nameToLine) {
            super(327680);
            this.nameToLine = nameToLine;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MV(this.nameToLine, name);
        }
    }
}

