/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import com.google.common.base.Strings;
import com.google.inject.Binder;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.runners.model.FrameworkMethod;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.SimpleFeature;

public class LogCaptureFeature
extends SimpleFeature {
    protected Filter logCaptureFilter;
    protected final Result myResult = new Result();
    protected Logger rootLogger = Logger.getRootLogger();
    protected Appender logAppender = new AppenderSkeleton(){

        public boolean requiresLayout() {
            return false;
        }

        public void close() {
        }

        protected void append(LoggingEvent event) {
            if (LogCaptureFeature.this.logCaptureFilter == null) {
                LogCaptureFeature.this.myResult.setNoFilterFlag(true);
                return;
            }
            if (LogCaptureFeature.this.logCaptureFilter.accept(event)) {
                LogCaptureFeature.this.myResult.caughtEvents.add(event);
            }
        }
    };
    private Filter setupCaptureFiler;

    @Override
    public void configure(FeaturesRunner runner, Binder binder) {
        binder.bind(Result.class).toInstance((Object)this.myResult);
    }

    @Override
    public void beforeSetup(FeaturesRunner runner) throws Exception {
        Filter filter;
        super.beforeSetup(runner);
        FilterWith filterProvider = runner.getConfig(FilterWith.class);
        if (filterProvider.value() == null) {
            FilterOn defaultFilterConfig = runner.getConfig(FilterOn.class);
            if (defaultFilterConfig == null) {
                return;
            }
            filter = new DefaultFilter(defaultFilterConfig.loggerName(), defaultFilterConfig.logLevel());
        } else {
            filter = filterProvider.value().newInstance();
        }
        this.enable(filter);
    }

    @Override
    public void afterTeardown(FeaturesRunner runner) throws Exception {
        this.disable();
    }

    @Override
    public void beforeMethodRun(FeaturesRunner runner, FrameworkMethod method, Object test) throws Exception {
        Filter filter;
        FilterWith filterProvider = runner.getConfig(method, FilterWith.class);
        if (filterProvider.value() == null) {
            FilterOn defaultFilterConfig = runner.getConfig(method, FilterOn.class);
            if (defaultFilterConfig == null) {
                return;
            }
            filter = new DefaultFilter(defaultFilterConfig.loggerName(), defaultFilterConfig.logLevel());
        } else {
            filter = filterProvider.value().newInstance();
        }
        this.enable(filter);
    }

    @Override
    public void afterMethodRun(FeaturesRunner runner, FrameworkMethod method, Object test) throws Exception {
        this.disable();
    }

    protected void enable(Filter filter) throws InstantiationException, IllegalAccessException {
        if (this.logCaptureFilter != null) {
            this.setupCaptureFiler = this.logCaptureFilter;
        } else {
            this.rootLogger.addAppender(this.logAppender);
        }
        this.logCaptureFilter = filter;
    }

    protected void disable() {
        if (this.setupCaptureFiler != null) {
            this.logCaptureFilter = this.setupCaptureFiler;
            this.setupCaptureFiler = null;
            return;
        }
        if (this.logCaptureFilter != null) {
            this.myResult.clear();
            this.rootLogger.removeAppender(this.logAppender);
            this.logCaptureFilter = null;
        }
    }

    public static interface Filter {
        public boolean accept(LoggingEvent var1);
    }

    public class Result {
        protected final ArrayList<LoggingEvent> caughtEvents = new ArrayList();
        protected boolean noFilterFlag = false;

        public void assertHasEvent() throws NoLogCaptureFilterException {
            if (this.noFilterFlag) {
                throw new NoLogCaptureFilterException();
            }
            Assert.assertFalse((String)"No log result found", (boolean)this.caughtEvents.isEmpty());
        }

        public void clear() {
            this.caughtEvents.clear();
            this.noFilterFlag = false;
        }

        public List<LoggingEvent> getCaughtEvents() {
            return this.caughtEvents;
        }

        protected void setNoFilterFlag(boolean noFilterFlag) {
            this.noFilterFlag = noFilterFlag;
        }
    }

    private static class DefaultFilter
    implements Filter {
        String loggerName;
        Level logLevel;

        public DefaultFilter(String loggerName, String logLevel) {
            this.loggerName = Strings.emptyToNull((String)loggerName);
            if (!"".equals(logLevel)) {
                this.logLevel = Level.toLevel((String)logLevel);
            }
        }

        @Override
        public boolean accept(LoggingEvent event) {
            if (this.logLevel != null && !this.logLevel.equals((Object)event.getLevel())) {
                return false;
            }
            return this.loggerName == null || this.loggerName.equals(event.getLoggerName());
        }
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface FilterOn {
        public String loggerName() default "";

        public String logLevel() default "";
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface FilterWith {
        public Class<? extends Filter> value();
    }

    public class NoLogCaptureFilterException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

