/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RuntimeHarness;

public class HotDeployer {
    public static final String DEPLOY_ACTION = "deploy";
    public static final String RESTART_ACTION = "restart";
    public static final String RESET_ACTION = "reset";
    protected FeaturesRunner runner;
    protected RuntimeHarness harness;
    protected ActionHandler head;

    public HotDeployer(FeaturesRunner runner, RuntimeHarness harness) {
        this.runner = runner;
        this.harness = harness;
        this.head = new DefaultDeployHandler();
    }

    public HotDeployer addHandler(ActionHandler action) {
        action.next = this.head;
        this.head = action;
        return this;
    }

    public boolean removeHandler(ActionHandler handler) {
        ActionHandler p = null;
        ActionHandler h = this.head;
        while (h != null && h != handler) {
            p = h;
            h = h.next;
        }
        if (h != null) {
            if (p == null) {
                this.head = h.next;
            } else {
                p.next = h.next;
            }
            h.next = null;
            return true;
        }
        return false;
    }

    public void deploy(String ... contribs) throws Exception {
        this.head.exec(DEPLOY_ACTION, contribs);
        this.reinject();
    }

    public void restart() throws Exception {
        this.head.exec(RESTART_ACTION, new String[0]);
        this.reinject();
    }

    public void reset() throws Exception {
        this.head.exec(RESET_ACTION, new String[0]);
        this.reinject();
    }

    public void reinject() {
        this.runner.getInjector().injectMembers(this.runner.getTargetTestInstance());
    }

    protected class DefaultDeployHandler
    extends ActionHandler {
        protected DefaultDeployHandler() {
        }

        @Override
        public void exec(String action, String ... args) throws Exception {
            if (HotDeployer.DEPLOY_ACTION.equals(action)) {
                this.deploy(args);
            } else if (HotDeployer.RESTART_ACTION.equals(action)) {
                this.restart();
            } else if (HotDeployer.RESET_ACTION.equals(action)) {
                this.reset();
            }
        }

        public void deploy(String ... contribs) throws Exception {
            if (contribs != null && contribs.length > 0) {
                for (String contrib : contribs) {
                    int i = contrib.indexOf(58);
                    if (i > -1) {
                        String bundleId = contrib.substring(0, i);
                        if (bundleId.startsWith("@")) {
                            bundleId = bundleId.substring(1);
                            HotDeployer.this.harness.deployTestContrib(bundleId, contrib.substring(i + 1));
                            continue;
                        }
                        HotDeployer.this.harness.deployContrib(bundleId, contrib.substring(i + 1));
                        continue;
                    }
                    HotDeployer.this.harness.deployBundle(contrib);
                }
            }
            Framework.getRuntime().getComponentManager().refresh(false);
        }

        public void restart() throws Exception {
            Framework.getRuntime().getComponentManager().restart(false);
        }

        public void reset() throws Exception {
            Framework.getRuntime().getComponentManager().restart(true);
        }
    }

    public static abstract class ActionHandler {
        protected ActionHandler next;

        public abstract void exec(String var1, String ... var2) throws Exception;
    }
}

