/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.protocols.inline;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.nuxeo.common.utils.URLStreamHandlerFactoryInstaller;
import org.nuxeo.runtime.test.protocols.inline.InlineURLStreamHandlerFactory;

public class InlineURLFactory {
    protected static URLStreamHandlerFactory shf;
    protected static final Pattern pattern;

    public static void install() {
        shf = new InlineURLStreamHandlerFactory();
        try {
            URLStreamHandlerFactoryInstaller.installURLStreamHandlerFactory((URLStreamHandlerFactory)shf);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot install inline URLs", e);
        }
    }

    public static void uninstall() {
        try {
            URLStreamHandlerFactoryInstaller.uninstallURLStreamHandlerFactory((URLStreamHandlerFactory)shf);
        }
        catch (Exception cause) {
            throw new RuntimeException("Cannot uninstall inline URLs", cause);
        }
        finally {
            shf = null;
        }
    }

    public static <T> byte[] marshall(T content) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(content);
        return bos.toByteArray();
    }

    public static <T> T unmarshall(Class<T> clazz, byte[] data) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        ObjectInputStream ois = new ObjectInputStream(is);
        try {
            return clazz.cast(ois.readObject());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot decode, object is not of class " + clazz.getSimpleName(), e);
        }
    }

    public static <T> URL newURL(T content) throws IOException {
        byte[] data = InlineURLFactory.marshall(content);
        return InlineURLFactory.newURL("application/java", data);
    }

    public static URL newURL(String mimetype, byte[] data) throws IOException {
        return new URL("inline:".concat(mimetype).concat(";base64,".concat(Base64.encodeBase64String((byte[])data))));
    }

    public static <T> T newObject(Class<T> clazz, URL url) throws IOException {
        byte[] data = InlineURLFactory.getBytes(url);
        return InlineURLFactory.unmarshall(clazz, data);
    }

    public static byte[] getBytes(URL url) throws IOException {
        Matcher matcher = pattern.matcher(url.toExternalForm());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("'" + url + "' should be 'inline:mimetype;base64,content'");
        }
        String mimetype = matcher.group(1);
        String data = matcher.group(2);
        return Base64.decodeBase64((String)data);
    }

    static {
        pattern = Pattern.compile("inline:(.*);base64,(.*)");
    }
}

