/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.DataSourceHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.NXRuntimeTestCase;
import org.nuxeo.runtime.test.runner.DeploymentSet;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.JndiHelper;
import org.nuxeo.runtime.test.runner.RunnerFeature;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.nuxeo.runtime.test.runner.ServiceProvider;
import org.nuxeo.runtime.test.runner.SimpleFeature;

public class RuntimeFeature
extends SimpleFeature {
    private static final Log log = LogFactory.getLog(RuntimeFeature.class);
    protected RuntimeHarness harness = new NXRuntimeTestCase();
    protected final DeploymentSet deploy = new DeploymentSet();
    protected final Map<Class<?>, Provider<?>> serviceProviders = new HashMap();

    public <T> void addServiceProvider(Class<T> clazz, Provider<T> provider) {
        this.serviceProviders.put(clazz, provider);
    }

    public RuntimeHarness getHarness() {
        return this.harness;
    }

    public DeploymentSet deployments() {
        return this.deploy;
    }

    private void scanDeployments(FeaturesRunner runner) {
        List<RunnerFeature> features = runner.getFeatures();
        if (features == null) {
            throw new IllegalStateException("Cannot call scanDeployments until features are not loaded");
        }
        for (RunnerFeature feature : features) {
            this.deploy.load(FeaturesRunner.getScanner(), feature.getClass());
        }
        this.deploy.load(FeaturesRunner.getScanner(), runner.getTestClass().getJavaClass());
    }

    public String[] getDeployments() {
        return this.deploy.getDeployments().toArray(new String[this.deploy.getDeployments().size()]);
    }

    public String[] getLocalDeployments() {
        return this.deploy.getLocalDeployments().toArray(new String[this.deploy.getLocalDeployments().size()]);
    }

    protected void deployTestClassBundles() throws Exception {
        String[] localResources;
        String[] bundles = this.getDeployments();
        if (bundles.length > 0) {
            this.harness = this.getHarness();
            for (String bundle : bundles) {
                try {
                    int p = bundle.indexOf(58);
                    if (p == -1) {
                        this.harness.deployBundle(bundle);
                        continue;
                    }
                    this.harness.deployContrib(bundle.substring(0, p), bundle.substring(p + 1));
                }
                catch (Exception e) {
                    log.error((Object)("Unable to deploy artifact: " + bundle), (Throwable)e);
                }
            }
        }
        if ((localResources = this.getLocalDeployments()).length > 0) {
            this.harness = this.getHarness();
            for (String bundle : localResources) {
                try {
                    int p = bundle.indexOf(58);
                    if (p == -1) {
                        throw new IllegalArgumentException("Local resources must specify a traget bundle. " + bundle);
                    }
                    URL url = this.getClass().getClassLoader().getResource(bundle.substring(p + 1));
                    this.harness.deployTestContrib(bundle.substring(0, p), url);
                }
                catch (Exception e) {
                    log.error((Object)("Unable to deploy artifact: " + bundle), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void initialize(FeaturesRunner runner) throws Exception {
        this.scanDeployments(runner);
    }

    @Override
    public void start(FeaturesRunner runner) throws Exception {
        if (!this.harness.isStarted()) {
            this.harness.start();
        }
        this.deployTestClassBundles();
    }

    @Override
    public void beforeRun(FeaturesRunner runner) throws Exception {
        this.harness.fireFrameworkStarted();
    }

    @Override
    public void stop(FeaturesRunner runner) throws Exception {
        if (this.harness.isStarted()) {
            this.harness.stop();
        }
    }

    @Override
    public void configure(FeaturesRunner runner, Binder binder) {
        for (String svc : Framework.getRuntime().getComponentManager().getServices()) {
            try {
                Class<?> clazz = Class.forName(svc);
                Provider<?> provider = this.serviceProviders.get(clazz);
                if (provider == null) {
                    this.bind0(binder, clazz);
                    continue;
                }
                this.bind0(binder, clazz, provider);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to bind service: " + svc, e);
            }
        }
        binder.bind(RuntimeHarness.class).toInstance((Object)this.getHarness());
    }

    protected <T> void bind0(Binder binder, Class<T> type) {
        binder.bind(type).toProvider(new ServiceProvider(type)).in(Scopes.SINGLETON);
    }

    protected <T> void bind0(Binder binder, Class<T> type, Provider<T> provider) {
        binder.bind(type).toProvider(provider).in(Scopes.SINGLETON);
    }

    public static void bindDatasource(String key, DataSource ds) throws Exception {
        InitialContext initialCtx = new InitialContext();
        JndiHelper.rebind((Context)initialCtx, DataSourceHelper.getDataSourceJNDIName((String)key), (Object)ds);
    }
}

