/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.reload;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.JarUtils;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.SharedResourceLoader;
import org.nuxeo.runtime.deployment.preprocessor.DeploymentPreprocessor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.reload.ReloadService;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class ReloadComponent
extends DefaultComponent
implements ReloadService {
    private static final Log log = LogFactory.getLog(ReloadComponent.class);
    protected static Bundle bundle;
    protected Long lastFlushed;

    public static BundleContext getBundleContext() {
        return bundle.getBundleContext();
    }

    public static Bundle getBundle() {
        return bundle;
    }

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        bundle = context.getRuntimeContext().getBundle();
    }

    public void deactivate(ComponentContext context) throws Exception {
        super.deactivate(context);
        bundle = null;
    }

    @Override
    public void reload() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting reload");
        }
        this.reloadProperties();
        EventService eventService = (EventService)Framework.getLocalService(EventService.class);
        eventService.sendEvent(new Event("org.nuxeo.runtime.reload", "reload", (Object)this, null));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Reload done");
        }
    }

    @Override
    public void reloadProperties() throws Exception {
        log.info((Object)"Reload runtime properties");
        Framework.getRuntime().reloadProperties();
    }

    @Override
    public void reloadRepository() throws Exception {
        log.info((Object)"Reload repository");
        ((EventService)Framework.getLocalService(EventService.class)).sendEvent(new Event("org.nuxeo.runtime.reload", "reloadRepositories", (Object)this, null));
    }

    @Override
    public void reloadSeamComponents() throws Exception {
        log.info((Object)"Reload Seam components");
        ((EventService)Framework.getLocalService(EventService.class)).sendEvent(new Event("org.nuxeo.runtime.reload", "reloadSeamComponents", (Object)this, null));
    }

    @Override
    public void flush() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting flush");
        }
        this.flushJaasCache();
        EventService eventService = (EventService)Framework.getLocalService(EventService.class);
        eventService.sendEvent(new Event("org.nuxeo.runtime.reload", "flush", (Object)this, null));
        this.setFlushedNow();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Flush done");
        }
    }

    @Override
    public void flushJaasCache() throws Exception {
        log.info((Object)"Flush the JAAS cache");
        EventService eventService = (EventService)Framework.getLocalService(EventService.class);
        eventService.sendEvent(new Event("usermanager", "user_changed", (Object)this, (Object)"Deployer"));
        this.setFlushedNow();
    }

    @Override
    public void flushSeamComponents() throws Exception {
        log.info((Object)"Flush Seam components");
        ((EventService)Framework.getLocalService(EventService.class)).sendEvent(new Event("org.nuxeo.runtime.reload", "flushSeamComponents", (Object)this, null));
        this.setFlushedNow();
    }

    @Override
    public String deployBundle(File file) throws Exception {
        return this.deployBundle(file, false);
    }

    @Override
    public String deployBundle(File file, boolean reloadResourceClasspath) throws MalformedURLException, BundleException {
        Bundle newBundle;
        String name = this.getOSGIBundleName(file);
        if (name == null) {
            log.error((Object)String.format("No Bundle-SymbolicName found in MANIFEST for jar at '%s'", file.getAbsolutePath()));
            return null;
        }
        String path = file.getAbsolutePath();
        log.info((Object)String.format("Before deploy bundle for file at '%s'\n%s", path, this.getRuntimeStatus()));
        if (reloadResourceClasspath) {
            URL url = new File(path).toURI().toURL();
            Framework.reloadResourceLoader(Arrays.asList(url), null);
        }
        if ((newBundle = ReloadComponent.getBundleContext().installBundle(path)) == null) {
            throw new IllegalArgumentException("Could not find a valid bundle at path: " + path);
        }
        newBundle.start();
        log.info((Object)String.format("Deploy done for bundle with name '%s'.\n%s", newBundle.getSymbolicName(), this.getRuntimeStatus()));
        return newBundle.getSymbolicName();
    }

    @Override
    public void undeployBundle(File file, boolean reloadResources) throws Exception {
        String name = this.getOSGIBundleName(file);
        String path = file.getAbsolutePath();
        if (name == null) {
            log.error((Object)String.format("No Bundle-SymbolicName found in MANIFEST for jar at '%s'", path));
            return;
        }
        this.undeployBundle(name);
        if (reloadResources) {
            URL url = new File(path).toURI().toURL();
            Framework.reloadResourceLoader(null, Arrays.asList(url));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeployBundle(String bundleName) throws Exception {
        if (bundleName == null) {
            return;
        }
        log.info((Object)String.format("Before undeploy bundle with name '%s'.\n%s", bundleName, this.getRuntimeStatus()));
        BundleContext ctx = ReloadComponent.getBundleContext();
        ServiceReference ref = ctx.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin srv = (PackageAdmin)ctx.getService(ref);
        try {
            for (Bundle b : srv.getBundles(bundleName, null)) {
                if (b == null || b.getState() != 32) continue;
                b.stop();
                b.uninstall();
            }
        }
        finally {
            ctx.ungetService(ref);
        }
        log.info((Object)String.format("Undeploy done.\n%s", this.getRuntimeStatus()));
    }

    @Override
    public Long lastFlushed() {
        return this.lastFlushed;
    }

    protected void setFlushedNow() {
        this.lastFlushed = System.currentTimeMillis();
    }

    @Override
    @Deprecated
    public void installWebResources(File file) throws Exception {
        log.info((Object)"Install web resources");
        if (file.isDirectory()) {
            File war = new File(file, "web");
            if ((war = new File(war, "nuxeo.war")).isDirectory()) {
                FileUtils.copyTree((File)war, (File)ReloadComponent.getAppDir());
            } else {
                war = new File(file, "nuxeo.war");
                if (war.isDirectory()) {
                    FileUtils.copyTree((File)war, (File)ReloadComponent.getAppDir());
                }
            }
        } else if (file.isFile()) {
            File war = ReloadComponent.getWarDir();
            ZipUtils.unzip((String)"web/nuxeo.war", (File)file, (File)war);
            ZipUtils.unzip((String)"nuxeo.war", (File)file, (File)war);
        }
    }

    protected static void reloadResourceClassPath(Collection<String> files) throws Exception {
        Framework.reloadResourceLoader();
        SharedResourceLoader loader = Framework.getResourceLoader();
        if (files != null) {
            for (String path : files) {
                URL url = new File(path).toURI().toURL();
                loader.addURL(url);
            }
        }
    }

    @Override
    public void runDeploymentPreprocessor() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start running deployment preprocessor");
        }
        String rootPath = Environment.getDefault().getHome().getAbsolutePath();
        File root = new File(rootPath);
        DeploymentPreprocessor processor = new DeploymentPreprocessor(root);
        processor.init();
        processor.predeploy();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deployment preprocessing done");
        }
    }

    protected static File getAppDir() {
        return Environment.getDefault().getConfig().getParentFile();
    }

    protected static File getWarDir() {
        return new File(ReloadComponent.getAppDir(), "nuxeo.war");
    }

    @Override
    public String getOSGIBundleName(File file) {
        Manifest mf = JarUtils.getManifest((File)file);
        if (mf == null) {
            return null;
        }
        String bundleName = mf.getMainAttributes().getValue("Bundle-SymbolicName");
        if (bundleName == null) {
            return null;
        }
        int index = bundleName.indexOf(59);
        if (index > -1) {
            bundleName = bundleName.substring(0, index);
        }
        return bundleName;
    }

    protected String getRuntimeStatus() {
        StringBuilder msg = new StringBuilder();
        RuntimeService runtime = Framework.getRuntime();
        runtime.getStatusMessage(msg);
        return msg.toString();
    }
}

