/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor.install.commands;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.FileNamePattern;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.runtime.deployment.preprocessor.install.Command;
import org.nuxeo.runtime.deployment.preprocessor.install.CommandContext;

public class AppendCommand
implements Command {
    protected final Path src;
    protected final Path dst;
    protected final boolean addNewLine;
    protected final FileNamePattern pattern;

    public AppendCommand(Path src, Path dst, boolean addNewLine, FileNamePattern pattern) {
        this.src = src;
        this.dst = dst;
        this.addNewLine = addNewLine;
        this.pattern = pattern;
    }

    public AppendCommand(Path src, Path dst) {
        this(src, dst, true, null);
    }

    @Override
    public void exec(CommandContext ctx) throws IOException {
        File baseDir = ctx.getBaseDir();
        File srcFile = new File(baseDir, ctx.expandVars(this.src.toString()));
        File dstFile = new File(baseDir, ctx.expandVars(this.dst.toString()));
        if (this.pattern == null && !srcFile.exists()) {
            throw new FileNotFoundException("Could not find the file " + srcFile.getAbsolutePath() + " to append.");
        }
        if (!dstFile.isFile()) {
            try {
                dstFile.createNewFile();
            }
            catch (IOException e) {
                throw new IOException("Could not create " + dstFile, e);
            }
        }
        if (this.pattern == null) {
            this.append(srcFile, dstFile, this.addNewLine);
        } else {
            ArrayList files = new ArrayList();
            FileUtils.collectFiles((File)srcFile, (FileNamePattern)this.pattern, files);
            for (File file : files) {
                this.append(file, dstFile, false);
            }
        }
    }

    public String toString() {
        return "append " + this.src.toString() + " > " + this.dst.toString();
    }

    @Override
    public String toString(CommandContext ctx) {
        return "append " + ctx.expandVars(this.src.toString()) + " > " + ctx.expandVars(this.dst.toString());
    }

    private void append(File srcFile, File dstFile, boolean appendNewLine) throws IOException {
        String dstExt;
        String srcExt = FileUtils.getFileExtension((String)srcFile.getName());
        if (StringUtils.equalsIgnoreCase((String)srcExt, (String)(dstExt = FileUtils.getFileExtension((String)dstFile.getName()))) && "json".equalsIgnoreCase(srcExt)) {
            ObjectMapper m = new ObjectMapper();
            ObjectNode destNode = (ObjectNode)m.readValue(dstFile, ObjectNode.class);
            ObjectNode srcNode = (ObjectNode)m.readValue(srcFile, ObjectNode.class);
            destNode.setAll(srcNode);
            m.writeValue(dstFile, (Object)destNode);
        } else {
            FileUtils.append((File)srcFile, (File)dstFile, (boolean)appendNewLine);
        }
    }
}

