/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.jndi.InitContextAccessor;
import org.nuxeo.common.jndi.NamingContextFactory;
import org.nuxeo.runtime.datasource.DataSourceDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DataSourceComponent
extends DefaultComponent {
    private static final Log log = LogFactory.getLog(DataSourceComponent.class);
    public static final String DATASOURCES_XP = "datasources";
    public static final String ENV_CTX_NAME = "java:comp/env";
    protected boolean isNamingOwner;

    public void activate(ComponentContext context) throws Exception {
        Context ctx = InitContextAccessor.getInitCtx();
        if (ctx != null) {
            if (InitContextAccessor.isWritable((Context)ctx)) {
                return;
            }
            NamingContextFactory.setDelegateContext((Context)ctx);
            NamingContextFactory.setDelegateEnvironment(ctx.getEnvironment());
        }
        this.isNamingOwner = true;
    }

    public void deactivate(ComponentContext context) throws Exception {
        if (this.isNamingOwner) {
            NamingContextFactory.revertSetAsInitial();
            this.isNamingOwner = false;
        }
    }

    public void registerContribution(Object contrib, String extensionPoint, ComponentInstance component) throws Exception {
        if (DATASOURCES_XP.equals(extensionPoint)) {
            if (contrib instanceof DataSourceDescriptor) {
                this.addDataSource((DataSourceDescriptor)contrib);
            } else {
                log.error((Object)("Invalid datasource contribution: " + contrib.getClass().getName()));
            }
        } else {
            log.error((Object)("Ignoring unknown extension point: " + extensionPoint));
        }
    }

    public void unregisterContribution(Object contrib, String extensionPoint, ComponentInstance component) throws Exception {
        if (DATASOURCES_XP.equals(extensionPoint)) {
            if (contrib instanceof DataSourceDescriptor) {
                this.removeDataSource((DataSourceDescriptor)contrib);
            } else {
                log.error((Object)("Invalid datasource contribution: " + contrib.getClass().getName()));
            }
        } else {
            log.error((Object)("Ignoring unknown extension point: " + extensionPoint));
        }
    }

    protected void addDataSource(DataSourceDescriptor descr) {
        log.info((Object)("Registering datasource: " + descr.name));
        try {
            CompositeName name = new CompositeName("java:comp/env/" + descr.name);
            Context ctx = new InitialContext();
            for (int i = 0; i < name.size() - 1; ++i) {
                try {
                    ctx = (Context)ctx.lookup(name.get(i));
                    continue;
                }
                catch (NamingException e) {
                    ctx = ctx.createSubcontext(name.get(i));
                }
            }
            ctx.bind(name.get(name.size() - 1), (Object)descr.getReference());
        }
        catch (NamingException e) {
            log.error((Object)("Cannot bind datasource '" + descr.name + "' in JNDI"), (Throwable)e);
        }
    }

    protected void removeDataSource(DataSourceDescriptor descr) {
        log.info((Object)("Unregistering datasource: " + descr.name));
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind("java:comp/env/" + descr.name);
        }
        catch (NamingException e) {
            log.error((Object)("Cannot unbind datasource '" + descr.name + "' in JNDI"), (Throwable)e);
        }
    }
}

