/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import java.io.File;
import java.util.Properties;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.config.ServerConfigurator;

public class JBossConfigurator
extends ServerConfigurator {
    @Deprecated
    public static final String JBOSS_CONFIG = "server/default/deploy/nuxeo.ear/config";
    public static final String DEFAULT_CONFIGURATION = "default";
    public static final String STARTUP_CLASS = "org.jboss.Main";
    public static final String SHUTDOWN_CLASS = "org.jboss.Shutdown";
    private String configuration = null;
    public static final String JBOSS_HOME_DIR = "jboss.home.dir";

    public String getConfiguration() {
        if (this.configuration == null) {
            Properties userConfig = this.generator.getUserConfig();
            this.configuration = userConfig != null ? this.generator.getUserConfig().getProperty("org.nuxeo.ecm.jboss.configuration", DEFAULT_CONFIGURATION) : System.getProperty("org.nuxeo.ecm.jboss.configuration", DEFAULT_CONFIGURATION);
        }
        return this.configuration;
    }

    public JBossConfigurator(ConfigurationGenerator configurationGenerator) {
        super(configurationGenerator);
    }

    @Override
    public boolean isConfigured() {
        log.info((Object)"Detected JBoss server.");
        return this.getConfigDir().exists();
    }

    public String getConfigPath() {
        return this.getEARPath() + File.separator + "config";
    }

    private String getEARPath() {
        return "server" + File.separator + this.getConfiguration() + File.separator + "deploy" + File.separator + "nuxeo.ear";
    }

    @Override
    public String getDefaultDataDir() {
        String defaultDataDir = "server" + File.separator + this.getConfiguration() + File.separator + "data" + File.separator + "NXRuntime" + File.separator + "data";
        return defaultDataDir;
    }

    @Override
    public File getLogConfFile() {
        return new File(this.generator.getNuxeoHome(), "server" + File.separator + this.getConfiguration() + File.separator + "conf" + File.separator + "jboss-log4j.xml");
    }

    @Override
    public void checkPaths() throws ConfigurationException {
        super.checkPaths();
        this.checkPaths(this.getConfiguration());
        if (!this.getConfiguration().equals(DEFAULT_CONFIGURATION)) {
            this.checkPaths(DEFAULT_CONFIGURATION);
        }
        File oldPath = new File(this.generator.getDataDir(), "NXRuntime" + File.separator + "binaries");
        String message = "Please move 'binaries' directory from" + oldPath.getParent() + "to " + this.generator.getDataDir();
        this.checkPath(oldPath, message);
    }

    private void checkPaths(String jbossConfig) throws ConfigurationException {
        File oldPath = new File(this.generator.getNuxeoHome(), "server" + File.separator + jbossConfig + File.separator + "data" + File.separator + "h2");
        String message = "Please move 'h2' and 'derby' directories from" + oldPath.getParent() + "to " + this.generator.getDataDir();
        this.checkPath(oldPath, message);
        oldPath = new File(this.generator.getNuxeoHome(), "server" + File.separator + jbossConfig + File.separator + "data" + File.separator + "derby");
        this.checkPath(oldPath, message);
        oldPath = new File(this.generator.getNuxeoHome(), "server" + File.separator + jbossConfig + File.separator + "data" + File.separator + "NXRuntime" + File.separator + "binaries");
        message = "Please move 'binaries' directory from" + oldPath.getParent() + "to " + this.generator.getDataDir();
        this.checkPath(oldPath, message);
    }

    @Override
    public String getDefaultTmpDir() {
        String defaultTmpDir = "server" + File.separator + this.getConfiguration() + File.separator + "tmp";
        return defaultTmpDir;
    }

    @Override
    public File getConfigDir() {
        return new File(this.generator.getNuxeoHome(), this.getConfigPath());
    }

    @Override
    public void prepareWizardStart() {
    }

    @Override
    public void cleanupPostWizard() {
    }

    @Override
    public boolean isWizardAvailable() {
        return false;
    }

    @Override
    protected File getRuntimeHome() {
        return new File(this.generator.getNuxeoHome(), this.getEARPath());
    }

    @Override
    public File getServerLibDir() {
        return new File(this.generator.getNuxeoHome(), "common" + File.separator + "lib");
    }
}

