/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.xml.DOMConfigurator;
import org.nuxeo.launcher.commons.text.TextTemplate;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;

public abstract class ServerConfigurator {
    protected static final Log log = LogFactory.getLog(ServerConfigurator.class);
    protected static final String DEFAULT_LOG_DIR = "log";
    protected final ConfigurationGenerator generator;
    protected File dataDir = null;
    protected File logDir = null;
    private File pidDir = null;
    protected File libDir = null;
    private File tmpDir = null;
    public static final String[] NUXEO_SYSTEM_PROPERTIES = new String[]{"nuxeo.conf", "nuxeo.home"};

    public ServerConfigurator(ConfigurationGenerator configurationGenerator) {
        this.generator = configurationGenerator;
    }

    abstract boolean isConfigured();

    protected void parseAndCopy(Properties config) throws IOException {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !"nuxeo.defaults".equals(name);
            }
        };
        TextTemplate templateParser = new TextTemplate(config);
        templateParser.setTrim(true);
        templateParser.setParsingExtensions(config.getProperty("nuxeo.templates.parsing.extensions", "xml,properties,nx"));
        for (File includedTemplate : this.generator.getIncludedTemplates()) {
            if (includedTemplate.listFiles(filter) == null) continue;
            String outputDirectoryStr = config.getProperty(includedTemplate.getName() + ".target");
            File outputDirectory = outputDirectoryStr != null ? new File(this.generator.getNuxeoHome(), outputDirectoryStr) : this.getOutputDirectory();
            for (File in : includedTemplate.listFiles(filter)) {
                templateParser.processDirectory(in, new File(outputDirectory, in.getName()));
            }
        }
    }

    protected abstract File getOutputDirectory();

    protected abstract String getDefaultDataDir();

    protected abstract File getRuntimeHome();

    public File getDataDir() {
        if (this.dataDir == null) {
            this.dataDir = new File(this.generator.getNuxeoHome(), this.getDefaultDataDir());
        }
        return this.dataDir;
    }

    public File getLogDir() {
        if (this.logDir == null) {
            this.logDir = new File(this.generator.getNuxeoHome(), DEFAULT_LOG_DIR);
        }
        return this.logDir;
    }

    public void setDataDir(String dataDirStr) {
        this.dataDir = new File(dataDirStr);
        this.dataDir.mkdirs();
    }

    public void setLogDir(String logDirStr) {
        this.logDir = new File(logDirStr);
        this.logDir.mkdirs();
    }

    public void initLogs() {
        File logFile = this.getLogConfFile();
        try {
            System.out.println("Try to configure logs with " + logFile);
            System.setProperty("nuxeo.log.dir", this.getLogDir().getPath());
            DOMConfigurator.configure((URL)logFile.toURI().toURL());
            log.info((Object)"Logs successfully configured.");
        }
        catch (MalformedURLException e) {
            log.error((Object)("Could not initialize logs with " + logFile), (Throwable)e);
        }
    }

    public File getPidDir() {
        if (this.pidDir == null) {
            this.pidDir = this.getLogDir();
        }
        return this.pidDir;
    }

    public void setPidDir(String pidDirStr) {
        this.pidDir = new File(pidDirStr);
        this.pidDir.mkdirs();
    }

    public void checkPaths() throws ConfigurationException {
        File badInstanceClid = new File(this.generator.getNuxeoHome(), this.getDefaultDataDir() + File.separator + "instance.clid");
        if (badInstanceClid.exists() && !this.getDataDir().equals(new File(this.generator.getNuxeoHome(), this.getDefaultDataDir()))) {
            log.warn((Object)("Moving " + badInstanceClid + " to " + this.getDataDir() + "."));
            try {
                FileUtils.moveFileToDirectory((File)badInstanceClid, (File)this.getDataDir(), (boolean)true);
            }
            catch (IOException e) {
                throw new ConfigurationException("Move failed.", e);
            }
        }
    }

    public File getTmpDir() {
        if (this.tmpDir == null) {
            this.tmpDir = new File(this.generator.getNuxeoHome(), this.getDefaultTmpDir());
        }
        return this.tmpDir;
    }

    public abstract String getDefaultTmpDir();

    public void setTmpDir(String tmpDirStr) {
        this.tmpDir = new File(tmpDirStr);
        this.tmpDir.mkdirs();
    }

    public void setDirectory(String key, String directory) {
        String absoluteDirectory = this.setAbsolutePath(key, directory);
        if ("nuxeo.data.dir".equals(key)) {
            this.setDataDir(absoluteDirectory);
        } else if ("nuxeo.log.dir".equals(key)) {
            this.setLogDir(absoluteDirectory);
        } else if ("nuxeo.pid.dir".equals(key)) {
            this.setPidDir(absoluteDirectory);
        } else if ("nuxeo.tmp.dir".equals(key)) {
            this.setTmpDir(absoluteDirectory);
        } else {
            log.error((Object)("Unknown directory key: " + key));
        }
    }

    private String setAbsolutePath(String key, String directory) {
        if (!new File(directory).isAbsolute()) {
            directory = new File(this.generator.getNuxeoHome(), directory).getPath();
            this.generator.getUserConfig().setProperty(key, directory);
        }
        return directory;
    }

    public File getDirectory(String key) {
        if ("nuxeo.data.dir".equals(key)) {
            return this.getDataDir();
        }
        if ("nuxeo.log.dir".equals(key)) {
            return this.getLogDir();
        }
        if ("nuxeo.pid.dir".equals(key)) {
            return this.getPidDir();
        }
        if ("nuxeo.tmp.dir".equals(key)) {
            return this.getTmpDir();
        }
        log.error((Object)("Unknown directory key: " + key));
        return null;
    }

    protected void checkPath(File oldPath, String message) throws ConfigurationException {
        if (oldPath.exists()) {
            log.error((Object)"Deprecated paths used (NXP-5370, NXP-5460).");
            throw new ConfigurationException(message);
        }
    }

    public abstract File getLogConfFile();

    public void removeExistingLocks() {
        File lockFile = new File(this.getDataDir(), "h2" + File.separator + "nuxeo.lucene" + File.separator + "write.lock");
        if (lockFile.exists()) {
            log.info((Object)("Removing lock file " + lockFile));
            lockFile.delete();
        }
    }

    public abstract File getConfigDir();

    public abstract void prepareWizardStart();

    public abstract void cleanupPostWizard();

    public abstract boolean isWizardAvailable();

    public void dumpProperties(Properties userConfig) {
        Properties dumpedProperties = this.filterSystemProperties(userConfig);
        File dumpedFile = new File(this.generator.getConfigDir(), "configuration.properties");
        try {
            dumpedProperties.store(new FileOutputStream(dumpedFile, false), "Generated by " + this.getClass());
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
        }
        catch (IOException e) {
            log.error((Object)("Could not dump properties to " + dumpedFile), (Throwable)e);
        }
    }

    public Properties filterSystemProperties(Properties properties) {
        String key;
        Properties dumpedProperties = new Properties();
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            key = (String)propertyNames.nextElement();
            dumpedProperties.setProperty(key, properties.getProperty(key));
        }
        propertyNames = System.getProperties().propertyNames();
        while (propertyNames.hasMoreElements()) {
            key = (String)propertyNames.nextElement();
            dumpedProperties.remove(key);
        }
        for (String key2 : NUXEO_SYSTEM_PROPERTIES) {
            dumpedProperties.setProperty(key2, properties.getProperty(key2));
        }
        return dumpedProperties;
    }

    public File getNuxeoLibDir() {
        return new File(this.getRuntimeHome(), "lib");
    }

    public abstract File getServerLibDir();
}

