/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs;

import java.io.IOException;
import java.io.Serializable;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.bulk.BulkAdminService;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.io.BulkParameters;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="bulkAction")
public class BulkActionObject
extends DefaultObject {
    protected String query;

    public void initialize(Object ... args) {
        this.query = (String)args[0];
    }

    @POST
    @Path(value="{actionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response executeBulkAction(@PathParam(value="actionId") String actionId, String actionParams) throws IOException {
        BulkAdminService admin = (BulkAdminService)Framework.getService(BulkAdminService.class);
        if (!admin.getActions().contains(actionId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!admin.isHttpEnabled(actionId) && !this.getContext().getPrincipal().isAdministrator()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String repository = this.getContext().getCoreSession().getRepositoryName();
        String username = this.getContext().getPrincipal().getName();
        BulkCommand command = new BulkCommand.Builder(actionId, this.query).repository(repository).user(username).params(BulkParameters.paramsToMap((String)actionParams)).build();
        BulkService service = (BulkService)Framework.getService(BulkService.class);
        String commandId = service.submit(command);
        BulkStatus status = (BulkStatus)service.getStatus((Serializable)((Object)commandId));
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)status).build();
    }
}

