/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.test;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.test.DefaultRepositoryInit;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class DocumentDiffRepositoryInit
extends DefaultRepositoryInit {
    public static String getLeftDocPath() {
        return "/leftDoc";
    }

    public static String getRightDocPath() {
        return "/rightDoc";
    }

    public void populate(CoreSession session) {
        this.createLeftDoc(session);
        this.createRightDoc(session);
        TransactionHelper.commitOrRollbackTransaction();
        ((EventService)Framework.getService(EventService.class)).waitForAsyncCompletion();
        TransactionHelper.startTransaction();
    }

    protected DocumentModel createLeftDoc(CoreSession session) {
        DocumentModel doc = session.createDocumentModel("/", "leftDoc", "SampleType");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"My first sample"));
        doc.setPropertyValue("dc:description", (Serializable)((Object)"description"));
        doc.setPropertyValue("dc:created", (Serializable)DocumentDiffRepositoryInit.getCalendarNoMillis(2011, 11, 29, 11, 24, 25));
        doc.setPropertyValue("dc:creator", (Serializable)((Object)"Administrator"));
        doc.setPropertyValue("dc:modified", (Serializable)DocumentDiffRepositoryInit.getCalendarNoMillis(2011, 11, 29, 11, 24, 25));
        doc.setPropertyValue("dc:lastContributor", (Serializable)((Object)"Administrator"));
        doc.setPropertyValue("dc:contributors", (Serializable)new String[]{"Administrator", "joe", null});
        doc.setPropertyValue("dc:subjects", (Serializable)new String[]{"Art", "Architecture"});
        Blob blob = Blobs.createBlob((String)"Joe is rich.");
        blob.setFilename("Joe.txt");
        doc.setPropertyValue("file:content", (Serializable)blob);
        ArrayList files = new ArrayList();
        HashMap<String, Serializable> file = new HashMap<String, Serializable>();
        blob = Blobs.createBlob((String)"Content of the first blob");
        blob.setFilename("first_attachement.txt");
        file.put("file", (Serializable)blob);
        files.add(file);
        file = new HashMap();
        blob = Blobs.createBlob((String)"Content of the second blob");
        blob.setFilename("second_attachement.txt");
        file.put("file", (Serializable)blob);
        files.add(file);
        file = new HashMap();
        blob = Blobs.createBlob((String)"Content of the third blob");
        blob.setFilename("third_attachement.txt");
        file.put("file", (Serializable)blob);
        files.add(file);
        file = new HashMap();
        blob = Blobs.createBlob((String)"Content of the fourth blob");
        blob.setFilename("fourth_attachement.txt");
        file.put("file", (Serializable)blob);
        files.add(file);
        doc.setPropertyValue("files:files", (Serializable)files);
        doc.setPropertyValue("st:string", (Serializable)((Object)"a string property"));
        doc.setPropertyValue("st:textarea", (Serializable)((Object)"a textarea property"));
        doc.setPropertyValue("st:boolean", (Serializable)Boolean.valueOf(true));
        doc.setPropertyValue("st:integer", (Serializable)Integer.valueOf(10));
        doc.setPropertyValue("st:date", (Serializable)DocumentDiffRepositoryInit.getCalendarNoMillis(2011, 11, 28, 23, 0, 0));
        doc.setPropertyValue("st:htmlText", (Serializable)((Object)"&lt;p&gt;html text with &lt;strong&gt;&lt;span style=\"text-decoration: underline;\"&gt;styles&lt;/span&gt;&lt;/strong&gt;&lt;/p&gt;\n&lt;ul&gt;\n&lt;li&gt;and&lt;/li&gt;\n&lt;li&gt;nice&lt;/li&gt;\n&lt;li&gt;bullets&lt;/li&gt;\n&lt;/ul&gt;"));
        doc.setPropertyValue("st:multivalued", (Serializable)new String[]{"monday", "tuesday", "wednesday", "thursday"});
        HashMap<String, Object> complexPropValue = new HashMap<String, Object>();
        complexPropValue.put("stringItem", "string of a complex type");
        complexPropValue.put("booleanItem", true);
        complexPropValue.put("integerItem", 10);
        doc.setPropertyValue("ct:complex", (Serializable)complexPropValue);
        HashMap<String, Object> item1ComplexPropValue = new HashMap<String, Object>();
        item1ComplexPropValue.put("stringItem", "first element of a complex list");
        item1ComplexPropValue.put("booleanItem", true);
        item1ComplexPropValue.put("integerItem", 12);
        ArrayList<HashMap<String, Object>> complexListPropValue = new ArrayList<HashMap<String, Object>>();
        complexListPropValue.add(item1ComplexPropValue);
        doc.setPropertyValue("ct:complexList", (Serializable)complexListPropValue);
        ArrayList listOfListPropValue = new ArrayList();
        HashMap<String, Object> complexItem1 = new HashMap<String, Object>();
        complexItem1.put("stringItem", "first item");
        ArrayList<String> item1SubList = new ArrayList<String>();
        item1SubList.add("Monday");
        item1SubList.add("Tuesday");
        complexItem1.put("stringListItem", item1SubList);
        listOfListPropValue.add(complexItem1);
        HashMap<String, Object> complexItem2 = new HashMap<String, Object>();
        complexItem2.put("stringItem", "second item");
        ArrayList<String> item2SubList = new ArrayList<String>();
        item2SubList.add("Wednesday");
        item2SubList.add("Thursday");
        complexItem2.put("stringListItem", item2SubList);
        listOfListPropValue.add(complexItem2);
        doc.setPropertyValue("lol:listOfLists", (Serializable)listOfListPropValue);
        return session.createDocument(doc);
    }

    protected DocumentModel createRightDoc(CoreSession session) {
        DocumentModel doc = session.createDocumentModel("/", "rightDoc", "SampleType");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"My second sample"));
        doc.setPropertyValue("dc:created", (Serializable)DocumentDiffRepositoryInit.getCalendarNoMillis(2011, 11, 29, 11, 24, 50));
        doc.setPropertyValue("dc:creator", (Serializable)((Object)"Administrator"));
        doc.setPropertyValue("dc:modified", (Serializable)DocumentDiffRepositoryInit.getCalendarNoMillis(2011, 11, 30, 12, 5, 2));
        doc.setPropertyValue("dc:lastContributor", (Serializable)((Object)" Administrator "));
        doc.setPropertyValue("dc:contributors", (Serializable)new String[]{"anotherAdministrator", "joe", "jack"});
        doc.setPropertyValue("dc:subjects", (Serializable)new String[]{"Art"});
        Blob blob = Blobs.createBlob((String)"Joe is rich, Jack is not.");
        blob.setFilename("Jack.txt");
        doc.setPropertyValue("file:content", (Serializable)blob);
        ArrayList files = new ArrayList();
        HashMap<String, Serializable> file = new HashMap<String, Serializable>();
        blob = Blobs.createBlob((String)"Content of the first blob");
        blob.setFilename("first_attachement.txt");
        file.put("file", (Serializable)blob);
        files.add(file);
        file = new HashMap();
        blob = Blobs.createBlob((String)"Content of the second blob");
        blob.setFilename("the_file_name_is_different.txt");
        file.put("file", (Serializable)blob);
        files.add(file);
        file = new HashMap();
        blob = Blobs.createBlob((String)"Different content of the third blob");
        blob.setFilename("third_attachement.txt");
        file.put("file", (Serializable)blob);
        files.add(file);
        doc.setPropertyValue("files:files", (Serializable)files);
        doc.setPropertyValue("st:string", (Serializable)((Object)"a different string property"));
        doc.setPropertyValue("st:textarea", (Serializable)((Object)"a textarea property"));
        doc.setPropertyValue("st:integer", (Serializable)Integer.valueOf(10));
        doc.setPropertyValue("st:date", (Serializable)DocumentDiffRepositoryInit.getCalendarNoMillis(2011, 11, 28, 23, 0, 0));
        doc.setPropertyValue("st:htmlText", (Serializable)((Object)"&lt;p&gt;html  text modified with &lt;span style=\"text-decoration: underline;\"&gt;styles&lt;/span&gt;&lt;/p&gt;\n&lt;ul&gt;\n&lt;li&gt;and&lt;/li&gt;\n&lt;li&gt;nice&lt;/li&gt;\n&lt;li&gt;bullets&lt;/li&gt;\n&lt;/ul&gt;\n&lt;p&gt;&amp;nbsp;&lt;/p&gt;"));
        HashMap<String, Object> complexPropValue = new HashMap<String, Object>();
        complexPropValue.put("stringItem", "string of a complex type");
        complexPropValue.put("booleanItem", false);
        complexPropValue.put("dateItem", DocumentDiffRepositoryInit.getCalendarNoMillis(2011, 11, 29, 23, 0, 0));
        doc.setPropertyValue("ct:complex", (Serializable)complexPropValue);
        HashMap<String, Object> item1ComplexPropValue = new HashMap<String, Object>();
        item1ComplexPropValue.put("stringItem", "first element of a complex list");
        item1ComplexPropValue.put("booleanItem", false);
        item1ComplexPropValue.put("dateItem", DocumentDiffRepositoryInit.getCalendarNoMillis(2011, 11, 30, 23, 0, 0));
        HashMap<String, Object> item2ComplexPropValue = new HashMap<String, Object>();
        item2ComplexPropValue.put("stringItem", "second element of a complex list");
        item2ComplexPropValue.put("booleanItem", false);
        item2ComplexPropValue.put("integerItem", 20);
        ArrayList<HashMap<String, Object>> complexListPropValue = new ArrayList<HashMap<String, Object>>();
        complexListPropValue.add(item1ComplexPropValue);
        complexListPropValue.add(item2ComplexPropValue);
        doc.setPropertyValue("ct:complexList", (Serializable)complexListPropValue);
        ArrayList listOfListPropValue = new ArrayList();
        HashMap<String, Object> complexItem1 = new HashMap<String, Object>();
        complexItem1.put("stringItem", "first item");
        ArrayList<String> item1SubList = new ArrayList<String>();
        item1SubList.add("Monday");
        item1SubList.add("Tuesday");
        complexItem1.put("stringListItem", item1SubList);
        listOfListPropValue.add(complexItem1);
        HashMap<String, Object> complexItem2 = new HashMap<String, Object>();
        complexItem2.put("stringItem", "second item is different");
        ArrayList<String> item2SubList = new ArrayList<String>();
        item2SubList.add("Wednesday");
        item2SubList.add("Friday");
        item2SubList.add("Saturday");
        complexItem2.put("stringListItem", item2SubList);
        listOfListPropValue.add(complexItem2);
        HashMap<String, Object> complexItem3 = new HashMap<String, Object>();
        complexItem3.put("stringItem", "third item");
        ArrayList item3SubList = new ArrayList();
        item2SubList.add("July");
        item2SubList.add("August");
        complexItem3.put("stringListItem", item3SubList);
        listOfListPropValue.add(complexItem3);
        doc.setPropertyValue("lol:listOfLists", (Serializable)listOfListPropValue);
        return session.createDocument(doc);
    }

    public static Calendar getCalendarNoMillis(int year, int month, int day, int hourOfDay, int minute, int second) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day, hourOfDay, minute, second);
        cal.set(14, 0);
        return cal;
    }
}

