/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wizard.nav;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.wizard.nav.Page;

public class SimpleNavigationHandler {
    public static final String SKIP_PAGES_KEY = "nuxeo.wizard.skippedpages";
    protected static final String[] nav = new String[]{"Home|welcome.jsp|1|0", "NetworkBlocked|networkBlocked.jsp|0|0", "General|generalSettings.jsp|1|0", "Proxy|proxySettings.jsp|1|0", "DB|dbSettings.jsp|1|0", "Smtp|smtpSettings.jsp|1|0", "Connect|connectForm.jsp|1|0", "ConnectCallback|connectCallback.jsp|0|1", "ConnectFinish|connectFinish.jsp|0|0", "PackagesSelection|packagesSelection.jsp|1|0", "PackagesDownload|packagesDownload.jsp|1|0", "PackagesSelectionDone|packagesSelectionDone.jsp|0|0", "Recap|recapScreen.jsp|1|0", "Restart|reStarting.jsp|1|1", "Reset|Welcome.jsp|1|1", "PackageOptionsResource||1|1"};
    protected List<Page> pages = new ArrayList();
    protected static SimpleNavigationHandler instance;
    protected static Log log;

    public static SimpleNavigationHandler instance() {
        if (instance == null) {
            instance = new SimpleNavigationHandler();
        }
        return instance;
    }

    public static void reset() {
        instance = null;
    }

    protected SimpleNavigationHandler() {
        Page previousPage = null;
        for (int idx = 0; idx < nav.length; ++idx) {
            String token = nav[idx];
            Page page = new Page(token);
            this.pages.add(page);
            if (previousPage != null) {
                previousPage.next = page;
                page.prev = previousPage;
            }
            page.progress = new Double((double)(idx + 1) * (100.0 / (double)nav.length)).intValue();
            previousPage = page;
        }
        ConfigurationGenerator configurationGenerator = new ConfigurationGenerator();
        configurationGenerator.init();
        String skipPages = configurationGenerator.getUserConfig().getProperty(SKIP_PAGES_KEY, null);
        if (skipPages != null) {
            String[] pages2Skip;
            for (String pageKey : pages2Skip = skipPages.split(",")) {
                this.deactivatePage(pageKey);
            }
        }
    }

    public Page getDefaultPage() {
        return this.getCurrentPage(((Page)this.pages.get((int)0)).action);
    }

    public int getProgress(String action) {
        int activePageIdx = 0;
        int totalActivePages = 0;
        for (int idx = 0; idx < this.pages.size(); ++idx) {
            if (((Page)this.pages.get(idx)).isVisibleInNavigationMenu()) {
                ++totalActivePages;
            }
            if (!((Page)this.pages.get(idx)).getAction().equals(action)) continue;
            activePageIdx = totalActivePages;
        }
        if (totalActivePages == 0) {
            return 0;
        }
        return new Double((double)activePageIdx * (100.0 / (double)totalActivePages)).intValue();
    }

    public Page getCurrentPage(String action) {
        Page currentPage = null;
        currentPage = action == null || action.isEmpty() ? (Page)this.pages.get(0) : this.findPageByAction(action);
        if (currentPage == null) {
            log.warn((Object)("No Page found for action " + action));
            return null;
        }
        currentPage.navigated = true;
        return currentPage;
    }

    public Page findPageByAction(String action) {
        for (int idx = 0; idx < this.pages.size(); ++idx) {
            if (!((Page)this.pages.get(idx)).getAction().equals(action)) continue;
            return (Page)this.pages.get(idx);
        }
        return null;
    }

    public void activatePage(String action) {
        Page page = this.findPageByAction(action);
        if (page != null) {
            page.active = true;
        }
    }

    public void deactivatePage(String action) {
        Page page = this.findPageByAction(action);
        if (page != null) {
            page.active = false;
        }
    }

    public List<Page> getPages() {
        return this.pages;
    }

    static {
        log = LogFactory.getLog(SimpleNavigationHandler.class);
    }
}

