/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers;

import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshaller;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;

public class DocumentMarshaller
implements JsonMarshaller<Document> {
    @Override
    public String getType() {
        return "document";
    }

    @Override
    public Class<Document> getJavaType() {
        return Document.class;
    }

    @Override
    public Document read(JsonParser jp) throws Exception {
        return DocumentMarshaller.readDocument(jp);
    }

    protected static Document readDocument(JsonParser jp) throws Exception {
        String uid = null;
        String type = null;
        String path = null;
        String state = null;
        String lock = null;
        String repository = null;
        PropertyList facets = null;
        String changeToken = null;
        JsonToken tok = jp.nextToken();
        PropertyMap props = new PropertyMap();
        PropertyMap contextParameters = new PropertyMap();
        while (tok != JsonToken.END_OBJECT) {
            String key = jp.getCurrentName();
            tok = jp.nextToken();
            if (key.equals("uid")) {
                uid = jp.getText();
            } else if (key.equals("path")) {
                path = jp.getText();
            } else if (key.equals("type")) {
                type = jp.getText();
            } else if (key.equals("state")) {
                state = jp.getText();
            } else if (key.equals("lock")) {
                lock = jp.getText();
            } else if (key.equals("repository")) {
                repository = jp.getText();
            } else if (key.equals("title")) {
                props.set("dc:title", jp.getText());
            } else if (key.equals("lastModified")) {
                props.set("dc:modified", jp.getText());
            } else if (key.equals("properties")) {
                DocumentMarshaller.readProperties(jp, props);
            } else if (key.equals("facets")) {
                facets = DocumentMarshaller.readArrayProperty(jp);
            } else if (key.equals("changeToken")) {
                changeToken = jp.getText();
            } else if (key.equals("contextParameters")) {
                DocumentMarshaller.readProperties(jp, contextParameters);
            } else {
                jp.skipChildren();
            }
            tok = jp.nextToken();
        }
        return new Document(uid, type, facets, changeToken, path, state, lock, repository, props);
    }

    protected static void readProperties(JsonParser jp, PropertyMap props) throws Exception {
        JsonToken tok = jp.nextToken();
        while (tok != JsonToken.END_OBJECT) {
            String key = jp.getCurrentName();
            tok = jp.nextToken();
            if (tok == JsonToken.START_ARRAY) {
                props.set(key, DocumentMarshaller.readArrayProperty(jp));
            } else if (tok == JsonToken.START_OBJECT) {
                props.set(key, DocumentMarshaller.readObjectProperty(jp));
            } else {
                props.set(key, jp.getText());
            }
            tok = jp.nextToken();
        }
    }

    protected static PropertyMap readObjectProperty(JsonParser jp) throws Exception {
        PropertyMap map = new PropertyMap();
        DocumentMarshaller.readProperties(jp, map);
        return map;
    }

    protected static PropertyList readArrayProperty(JsonParser jp) throws Exception {
        PropertyList list = new PropertyList();
        JsonToken tok = jp.nextToken();
        while (tok != JsonToken.END_ARRAY) {
            if (tok == JsonToken.START_ARRAY) {
                list.add(DocumentMarshaller.readArrayProperty(jp));
            } else if (tok == JsonToken.START_OBJECT) {
                list.add(DocumentMarshaller.readObjectProperty(jp));
            } else {
                list.add(jp.getText());
            }
            tok = jp.nextToken();
        }
        return list;
    }

    @Override
    public void write(JsonGenerator jg, Document value) throws Exception {
        throw new UnsupportedOperationException();
    }
}

