/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.annotations.api.UriResolver;
import org.nuxeo.ecm.platform.annotations.repository.URNDocumentViewTranslator;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class DefaultNuxeoUriResolver
implements UriResolver {
    private static final String NUXEO = VirtualHostHelper.getContextPathProperty() + "/";
    private final URNDocumentViewTranslator translator = new URNDocumentViewTranslator();
    private DocumentViewCodecManager viewCodecManager = (DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class);

    public URI getSearchURI(URI uri) {
        DocumentView view = this.translator.getDocumentViewFromUri(uri);
        return this.getGraphURIFromDocumentView(view);
    }

    public URI translateFromGraphURI(URI uri, String baseUrl) {
        URI u;
        DocumentView view = this.translator.getDocumentViewFromUri(uri);
        if (view == null || baseUrl == null) {
            return uri;
        }
        String url = this.viewCodecManager.getUrlFromDocumentView(view, true, baseUrl);
        try {
            u = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new NuxeoException((Throwable)e);
        }
        return u;
    }

    public URI translateToGraphURI(URI uri) {
        if (uri.toString().startsWith("urn")) {
            return uri;
        }
        DocumentView view = this.viewCodecManager.getDocumentViewFromUrl(uri.toString(), true, this.getBaseUrl(uri));
        if (view == null) {
            return uri;
        }
        return this.getGraphURIFromDocumentView(view);
    }

    protected URI getGraphURIFromDocumentView(DocumentView view) {
        DocumentLocation docLoc = view.getDocumentLocation();
        try (CloseableCoreSession session = CoreInstance.openCoreSession((String)docLoc.getServerName());){
            IdRef idRef = docLoc.getIdRef();
            if (idRef == null) {
                DocumentModel docModel = session.getDocument(docLoc.getDocRef());
                idRef = docModel.getRef();
            }
            URI uRI = this.translator.getUriFromDocumentView(docLoc.getServerName(), (DocumentRef)idRef);
            return uRI;
        }
    }

    public String getBaseUrl(URI uri) {
        String url;
        try {
            url = uri.toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new NuxeoException((Throwable)e);
        }
        return url.substring(0, url.lastIndexOf(NUXEO) + NUXEO.length());
    }

    public DocumentRef getDocumentRef(URI uri) {
        return this.retrieveDocumentLocation(uri).map(DocumentLocation::getDocRef).orElse(null);
    }

    public DocumentLocation getDocumentLocation(URI uri) {
        return this.retrieveDocumentLocation(uri).orElse(null);
    }

    private Optional<DocumentLocation> retrieveDocumentLocation(URI uri) {
        Optional<DocumentView> view = this.translator.isNuxeoUrn(uri) ? Optional.of(this.translator.getDocumentViewFromUri(uri)) : Optional.ofNullable(this.viewCodecManager.getDocumentViewFromUrl(uri.toString(), true, this.getBaseUrl(uri)));
        return view.map(DocumentView::getDocumentLocation);
    }

    public URI getUri(DocumentView view, String baseUrl) throws URISyntaxException {
        return new URI(this.viewCodecManager.getUrlFromDocumentView(view, true, baseUrl));
    }
}

