/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.util.Map;
import org.nuxeo.common.xmap.AttributeValueMapVisitor;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.DOMHelper;
import org.nuxeo.common.xmap.ElementMapVisitor;
import org.nuxeo.common.xmap.ElementValueMapVisitor;
import org.nuxeo.common.xmap.Path;
import org.nuxeo.common.xmap.XAccessor;
import org.nuxeo.common.xmap.XAnnotatedList;
import org.nuxeo.common.xmap.XMLBuilder;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.w3c.dom.Element;

public class XAnnotatedMap
extends XAnnotatedList {
    protected static final ElementMapVisitor elementMapVisitor = new ElementMapVisitor();
    protected static final ElementValueMapVisitor elementVisitor = new ElementValueMapVisitor();
    protected static final AttributeValueMapVisitor attributeVisitor = new AttributeValueMapVisitor();
    protected final Path key;
    protected final boolean isNullByDefault;

    public XAnnotatedMap(XMap xmap, XAccessor setter, XNodeMap anno) {
        super(xmap, setter);
        this.path = new Path(anno.value());
        this.trim = anno.trim();
        this.key = new Path(anno.key());
        this.type = anno.type();
        this.componentType = anno.componentType();
        this.valueFactory = xmap.getValueFactory(this.componentType);
        this.xao = xmap.register(this.componentType);
        this.isNullByDefault = anno.nullByDefault();
    }

    @Override
    protected Object getValue(Context ctx, Element base) throws IllegalAccessException, InstantiationException {
        Map values = (Map)this.type.newInstance();
        if (this.xao != null) {
            DOMHelper.visitMapNodes(ctx, this, base, this.path, elementMapVisitor, values);
        } else if (this.path.attribute != null) {
            DOMHelper.visitMapNodes(ctx, this, base, this.path, attributeVisitor, values);
        } else {
            DOMHelper.visitMapNodes(ctx, this, base, this.path, elementVisitor, values);
        }
        if (this.isNullByDefault && values.isEmpty()) {
            values = null;
        }
        return values;
    }

    @Override
    public void toXML(Object instance, Element parent) throws Exception {
        block4: {
            Object v = this.accessor.getValue(instance);
            if (v == null || !(v instanceof Map)) break block4;
            Map map = (Map)v;
            if (this.xao == null) {
                for (Map.Entry entry : map.entrySet()) {
                    String entryKey = (String)entry.getKey();
                    String value = this.valueFactory.serialize(null, entry.getValue());
                    Element e = XMLBuilder.addElement(parent, this.path);
                    Element keyElement = XMLBuilder.getOrCreateElement(e, this.key);
                    XMLBuilder.fillField(keyElement, entryKey, this.key.attribute);
                    XMLBuilder.fillField(e, value, null);
                }
            } else {
                for (Map.Entry entry : map.entrySet()) {
                    String entryKey = (String)entry.getKey();
                    Element e = XMLBuilder.addElement(parent, this.path);
                    Element keyElement = XMLBuilder.getOrCreateElement(e, this.key);
                    XMLBuilder.fillField(keyElement, entryKey, this.key.attribute);
                    XMLBuilder.toXML(entry.getValue(), e, this.xao);
                }
            }
        }
    }
}

