/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIUtils {
    private static final Log log = LogFactory.getLog(URIUtils.class);

    private URIUtils() {
    }

    public static String getURIQuery(Map<String, String> parameters) {
        String query = null;
        if (parameters != null) {
            ArrayList<String> items = new ArrayList<String>();
            for (Map.Entry<String, String> paramInfo : parameters.entrySet()) {
                String key = paramInfo.getKey();
                String value = paramInfo.getValue();
                items.add(String.format("%s=%s", key, value));
            }
            query = StringUtils.join(items, "&");
        }
        return query;
    }

    public static Map<String, String> getRequestParameters(String uriQuery) {
        String[] items;
        HashMap<String, String> parameters = null;
        if (uriQuery != null && (items = uriQuery.split("&")) != null && items.length > 0) {
            parameters = new HashMap<String, String>();
            for (String item : items) {
                String[] param = item.split("=");
                if (param == null || param.length != 2) continue;
                parameters.put(param[0], param[1]);
            }
        }
        return parameters;
    }

    public static String addParametersToURIQuery(String uriString, Map<String, String> parameters) {
        String res = uriString;
        try {
            URI uri = URI.create(uriString);
            String query = uri.getQuery();
            Map<String, String> existingParams = URIUtils.getRequestParameters(query);
            if (existingParams == null) {
                existingParams = new HashMap<String, String>();
            }
            existingParams.putAll(parameters);
            String newQuery = URIUtils.getURIQuery(existingParams);
            URI newURI = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), newQuery, uri.getFragment());
            res = newURI.toString();
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"Failed to add new parameters to uri", (Throwable)e);
        }
        catch (URISyntaxException e) {
            log.error((Object)"Failed to add new parameters to uri", (Throwable)e);
        }
        return res;
    }
}

