/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.Resource;
import org.w3c.dom.Node;

public abstract class XValueFactory {
    static final Hashtable<Class, XValueFactory> defaultFactories = new Hashtable();
    public static final XValueFactory STRING = new XValueFactory(){

        public Object getValue(Context ctx, String value) {
            return value;
        }
    };
    public static final XValueFactory INTEGER = new XValueFactory(){

        public Object getValue(Context ctx, String value) {
            return Integer.valueOf(value);
        }
    };
    public static final XValueFactory LONG = new XValueFactory(){

        public Object getValue(Context ctx, String value) {
            return Long.valueOf(value);
        }
    };
    public static final XValueFactory DOUBLE = new XValueFactory(){

        public Object getValue(Context ctx, String value) {
            return Double.valueOf(value);
        }
    };
    public static final XValueFactory FLOAT = new XValueFactory(){

        public Object getValue(Context ctx, String value) {
            return Float.valueOf(value);
        }
    };
    public static final XValueFactory BOOLEAN = new XValueFactory(){

        public Object getValue(Context ctx, String value) {
            return Boolean.valueOf(value);
        }
    };
    public static final XValueFactory DATE = new XValueFactory(){
        final DateFormat df = DateFormat.getDateInstance();

        public Object getValue(Context ctx, String value) {
            try {
                return this.df.parse(value);
            }
            catch (Exception e) {
                return null;
            }
        }
    };
    public static final XValueFactory FILE = new XValueFactory(){

        public Object getValue(Context ctx, String value) {
            return new File(value);
        }
    };
    public static final XValueFactory URL = new XValueFactory(){

        public Object getValue(Context ctx, String value) {
            try {
                return new URL(value);
            }
            catch (Exception e) {
                return null;
            }
        }
    };
    public static final XValueFactory CLASS = new XValueFactory(){

        public Object getValue(Context ctx, String value) {
            try {
                return ctx.loadClass(value);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    };
    public static final XValueFactory RESOURCE = new XValueFactory(){

        public Object getValue(Context ctx, String value) {
            try {
                return new Resource(ctx.getResource(value));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    };

    public abstract Object getValue(Context var1, String var2);

    public final Object getElementValue(Context ctx, Node element, boolean trim) {
        String text = element.getTextContent();
        return this.getValue(ctx, trim ? text.trim() : text);
    }

    public final Object getAttributeValue(Context ctx, Node element, String name) {
        Node at = element.getAttributes().getNamedItem(name);
        return at != null ? this.getValue(ctx, at.getNodeValue()) : null;
    }

    public static void addFactory(Class klass, XValueFactory factory) {
        defaultFactories.put(klass, factory);
    }

    public static XValueFactory getFactory(Class type) {
        return defaultFactories.get(type);
    }

    public static Object getValue(Context ctx, Class klass, String value) {
        XValueFactory factory = defaultFactories.get(klass);
        if (factory == null) {
            return null;
        }
        return factory.getValue(ctx, value);
    }

    static {
        XValueFactory.addFactory(String.class, STRING);
        XValueFactory.addFactory(Integer.class, INTEGER);
        XValueFactory.addFactory(Long.class, LONG);
        XValueFactory.addFactory(Double.class, DOUBLE);
        XValueFactory.addFactory(Date.class, DATE);
        XValueFactory.addFactory(Boolean.class, BOOLEAN);
        XValueFactory.addFactory(File.class, FILE);
        XValueFactory.addFactory(URL.class, URL);
        XValueFactory.addFactory(Integer.TYPE, INTEGER);
        XValueFactory.addFactory(Long.TYPE, LONG);
        XValueFactory.addFactory(Double.TYPE, DOUBLE);
        XValueFactory.addFactory(Float.TYPE, FLOAT);
        XValueFactory.addFactory(Boolean.TYPE, BOOLEAN);
        XValueFactory.addFactory(Class.class, CLASS);
        XValueFactory.addFactory(Resource.class, RESOURCE);
    }
}

