/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.DOMHelper;
import org.nuxeo.common.xmap.Path;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.XSetter;
import org.nuxeo.common.xmap.XValueFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XAnnotatedMember {
    public final XMap xmap;
    public final XSetter setter;
    public Path path;
    public boolean trim;
    public Class type;
    public XAnnotatedObject xao;
    public XValueFactory valueFactory;

    protected XAnnotatedMember(XMap xmap, XSetter setter) {
        this.xmap = xmap;
        this.setter = setter;
    }

    public XAnnotatedMember(XMap xmap, XSetter setter, XNode anno) {
        this.xmap = xmap;
        this.setter = setter;
        this.path = new Path(anno.value());
        this.trim = anno.trim();
        this.type = setter.getType();
        this.valueFactory = xmap.getValueFactory(this.type);
        this.xao = xmap.register(this.type);
    }

    protected void setValue(Object instance, Object value) throws Exception {
        this.setter.setValue(instance, value);
    }

    public void process(Context ctx, Element element) throws Exception {
        Object value = this.getValue(ctx, element);
        if (value != null) {
            this.setValue(ctx.getObject(), value);
        }
    }

    protected Object getValue(Context ctx, Element base) throws Exception {
        if (this.xao != null) {
            Element el = (Element)DOMHelper.getElementNode((Node)base, this.path);
            return el == null ? null : this.xao.newInstance(ctx, el);
        }
        if (this.type == Element.class) {
            return base;
        }
        String val = DOMHelper.getNodeValue(base, this.path);
        if (val != null) {
            if (this.trim) {
                val = val.trim();
            }
            return this.valueFactory.getValue(ctx, val);
        }
        return null;
    }
}

