/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import org.nuxeo.common.xmap.AttributeValueVisitor;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.DOMHelper;
import org.nuxeo.common.xmap.ElementValueVisitor;
import org.nuxeo.common.xmap.ElementVisitor;
import org.nuxeo.common.xmap.Path;
import org.nuxeo.common.xmap.PrimitiveArrays;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.XSetter;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.w3c.dom.Element;

public class XAnnotatedList
extends XAnnotatedMember {
    protected static final ElementVisitor elementListVisitor = new ElementVisitor();
    protected static final ElementValueVisitor elementVisitor = new ElementValueVisitor();
    protected static final AttributeValueVisitor attributeVisitor = new AttributeValueVisitor();
    public Class componentType;

    protected XAnnotatedList(XMap xmap, XSetter setter) {
        super(xmap, setter);
    }

    public XAnnotatedList(XMap xmap, XSetter setter, XNodeList anno) {
        super(xmap, setter);
        this.path = new Path(anno.value());
        this.trim = anno.trim();
        this.type = anno.type();
        this.componentType = anno.componentType();
        this.valueFactory = xmap.getValueFactory(this.componentType);
        this.xao = xmap.register(this.componentType);
    }

    protected Object getValue(Context ctx, Element base) throws Exception {
        ArrayList<Object> values = new ArrayList<Object>();
        if (this.xao != null) {
            DOMHelper.visitNodes(ctx, this, base, this.path, elementListVisitor, values);
        } else if (this.path.attribute != null) {
            DOMHelper.visitNodes(ctx, this, base, this.path, attributeVisitor, values);
        } else {
            DOMHelper.visitNodes(ctx, this, base, this.path, elementVisitor, values);
        }
        if (this.type != ArrayList.class) {
            if (this.type.isArray()) {
                if (this.componentType.isPrimitive()) {
                    return PrimitiveArrays.toPrimitiveArray(values, this.componentType);
                }
                return values.toArray((Object[])Array.newInstance(this.componentType, values.size()));
            }
            Collection col = (Collection)this.type.newInstance();
            col.addAll(values);
            return col;
        }
        return values;
    }
}

