/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;

public final class SerializableHelper {
    private SerializableHelper() {
    }

    public static boolean isSerializable(Object ob) {
        if (!(ob instanceof Serializable)) {
            return false;
        }
        Serializable in = (Serializable)ob;
        try {
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
            ObjectOutputStream outStream = new ObjectOutputStream(byteOutStream);
            outStream.writeObject(in);
            ByteArrayInputStream byteInStream = new ByteArrayInputStream(byteOutStream.toByteArray());
            ObjectInputStream inStream = new ObjectInputStream(byteInStream);
            Object obs = inStream.readObject();
            return obs != null;
        }
        catch (OptionalDataException e) {
            return false;
        }
        catch (StreamCorruptedException e) {
            return false;
        }
        catch (NotSerializableException ex) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

