/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.common.utils.Path;
import org.nuxeo.common.utils.PathFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils {
    private static final int BUFFER_SIZE = 65536;
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private static final int MIN_BUFFER_SIZE = 8192;

    private FileUtils() {
    }

    public static void safeClose(Closeable stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static byte[] createBuffer(int preferredSize) {
        if (preferredSize < 1) {
            preferredSize = 65536;
        }
        if (preferredSize > 0x100000) {
            preferredSize = 0x100000;
        } else if (preferredSize < 8192) {
            preferredSize = 8192;
        }
        return new byte[preferredSize];
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = FileUtils.createBuffer(in.available());
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream in) throws IOException {
        StringBuffer sb = new StringBuffer();
        byte[] buffer = FileUtils.createBuffer(in.available());
        try {
            int read;
            while ((read = in.read(buffer)) != -1) {
                sb.append(new String(buffer, 0, read));
            }
        }
        finally {
            in.close();
        }
        return sb.toString();
    }

    public static byte[] readBytes(URL url) throws IOException {
        return FileUtils.readBytes(url.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream in) throws IOException {
        byte[] b;
        byte[] buffer = FileUtils.createBuffer(in.available());
        int read = 0;
        int w = 0;
        try {
            int len;
            do {
                if ((len = buffer.length - (w += read)) > 0) continue;
                b = new byte[buffer.length + 65536];
                System.arraycopy(buffer, 0, b, 0, w);
                buffer = b;
                len = buffer.length - w;
            } while ((read = in.read(buffer, w, len)) != -1);
        }
        finally {
            in.close();
        }
        if (buffer.length > w) {
            b = new byte[w];
            System.arraycopy(buffer, 0, b, 0, w);
            buffer = b;
        }
        return buffer;
    }

    public static String readFile(File file) throws IOException {
        return FileUtils.read(new FileInputStream(file));
    }

    public static List<String> readLines(File file) throws IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(File file, List<String> lines) throws IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileOutputStream(file));
            for (String line : lines) {
                out.println(line);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static byte[] readBytes(File file) throws IOException {
        return FileUtils.readBytes(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, byte[] buf) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(buf);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static void writeFile(File file, String buf) throws IOException {
        FileUtils.writeFile(file, buf.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(URL url, File file) throws IOException {
        InputStream in = url.openStream();
        FileOutputStream out = new FileOutputStream(file);
        try {
            FileUtils.copy(in, out);
        }
        finally {
            if (in != null) {
                in.close();
            }
            ((OutputStream)out).close();
        }
    }

    public static void deleteTree(File dir) {
        FileUtils.emptyDirectory(dir);
        dir.delete();
    }

    public static void emptyDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                FileUtils.deleteTree(file);
                continue;
            }
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyToFile(InputStream in, File file) throws IOException {
        FileOutputStream out = null;
        try {
            int read;
            out = new FileOutputStream(file);
            byte[] buffer = FileUtils.createBuffer(in.available());
            while ((read = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    public static void append(File src, File dst) throws IOException {
        FileUtils.append(src, dst, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(File src, File dst, boolean appendNewLine) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(src);
            FileUtils.append(in, dst, appendNewLine);
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    public static void append(InputStream in, File file) throws IOException {
        FileUtils.append(in, file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(InputStream in, File file, boolean appendNewLine) throws IOException {
        OutputStream out = null;
        try {
            int read;
            out = new BufferedOutputStream(new FileOutputStream(file, true));
            if (appendNewLine) {
                out.write(System.getProperty("line.separator").getBytes());
            }
            byte[] buffer = new byte[65536];
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void copy(File src, File dst) throws IOException {
        if (src.equals(dst)) {
            return;
        }
        if (src.isFile()) {
            FileUtils.copyFile(src, dst);
        } else {
            FileUtils.copyTree(src, dst);
        }
    }

    public static void copy(File[] src, File dst) throws IOException {
        for (File file : src) {
            FileUtils.copy(file, dst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) throws IOException {
        if (dst.isDirectory()) {
            dst = new File(dst, src.getName());
        }
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        try {
            FileUtils.copy(in, out);
        }
        finally {
            in.close();
            out.close();
        }
    }

    public static void copyTree(File src, File dst) throws IOException {
        if (src.isFile()) {
            FileUtils.copyFile(src, dst);
        } else if (src.isDirectory()) {
            File[] files;
            if (dst.exists()) {
                dst = new File(dst, src.getName());
                dst.mkdir();
            } else {
                dst.mkdirs();
            }
            for (File file : files = src.listFiles()) {
                FileUtils.copyTree(file, dst);
            }
        }
    }

    public static void copyTree(File src, File dst, PathFilter filter) throws IOException {
        if (!filter.accept(new Path(src.getAbsolutePath()))) {
            return;
        }
        if (src.isFile()) {
            FileUtils.copyFile(src, dst);
        } else if (src.isDirectory()) {
            File[] files;
            if (dst.exists()) {
                dst = new File(dst, src.getName());
                dst.mkdir();
            } else {
                dst.mkdirs();
            }
            for (File file : files = src.listFiles()) {
                FileUtils.copyTree(file, dst, filter);
            }
        }
    }

    public static String getFilePathFromUrl(URL url) {
        String path = "";
        if (url.getProtocol().equals("file")) {
            try {
                path = URLDecoder.decode(url.getPath(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return path;
    }

    public static File getFileFromURL(URL url) {
        String filename = FileUtils.getFilePathFromUrl(url);
        File file = filename.equals("") ? null : new File(filename);
        return file;
    }

    public static String getResourcePathFromContext(String resource) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
        return FileUtils.getFilePathFromUrl(url);
    }

    public static File getResourceFileFromContext(String resource) {
        String filename = FileUtils.getResourcePathFromContext(resource);
        File file = filename.equals("") ? null : new File(filename);
        return file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File[] findFiles(File root, String pattern, boolean recurse) {
        ArrayList<File> result = new ArrayList<File>();
        if (pattern == null) {
            if (!recurse) return root.listFiles();
            FileUtils.collectFiles(root, result);
            return result.toArray(new File[result.size()]);
        } else if (recurse) {
            FileUtils.collectFiles(root, pattern, result);
            return result.toArray(new File[result.size()]);
        } else {
            File[] files = root.listFiles();
            char[] pat = pattern.toCharArray();
            for (File file : files) {
                if (!FileUtils.matchPattern(file.getName(), pat)) continue;
                result.add(file);
            }
        }
        return result.toArray(new File[result.size()]);
    }

    public static void collectFiles(File root, String pattern, List<File> result) {
        File[] files = root.listFiles();
        char[] pat = pattern.toCharArray();
        for (File file : files) {
            if (!FileUtils.matchPattern(file.getName(), pat)) continue;
            result.add(file);
            if (!file.isDirectory()) continue;
            FileUtils.collectFiles(file, pattern, result);
        }
    }

    public static void collectFiles(File root, List<File> result) {
        File[] files;
        for (File file : files = root.listFiles()) {
            result.add(file);
            if (!file.isDirectory()) continue;
            FileUtils.collectFiles(root, result);
        }
    }

    public static boolean matchPattern(String fileName, char[] pattern) {
        return FileUtils.matchPattern(fileName.toCharArray(), pattern);
    }

    public static boolean matchPattern(char[] name, char[] pattern) {
        return FileUtils.matchPattern(name, 0, name.length, pattern);
    }

    public static boolean matchPattern(char[] name, int offset, int len, char[] pattern) {
        int i = offset;
        boolean wildcard = false;
        block4: for (char c : pattern) {
            switch (c) {
                case '*': {
                    wildcard = true;
                    continue block4;
                }
                case '?': {
                    ++i;
                    continue block4;
                }
                default: {
                    if (wildcard) {
                        while (i < len && name[i++] != c) {
                        }
                        if (i == len) {
                            return true;
                        }
                        wildcard = false;
                        continue block4;
                    }
                    if (i >= len || name[i] != c) {
                        return false;
                    }
                    ++i;
                }
            }
        }
        return wildcard || i == len;
    }
}

