/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.collections;

import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayMap<K, V> {
    protected static final int DEFAULT_SIZE = 8;
    protected static final int GROW_SIZE = 10;
    protected int count = 0;
    protected Object[] elements;

    public ArrayMap() {
    }

    public ArrayMap(int initialCapacity) {
        this.elements = new Object[initialCapacity == 0 ? 8 : initialCapacity * 2];
    }

    public ArrayMap(Map map) {
        this(map.size());
        this.putAll(map);
    }

    public ArrayMap(ArrayMap map) {
        this.count = map.count;
        this.elements = new Object[map.elements.length];
        System.arraycopy(map.elements, 0, this.elements, 0, this.count * 2);
    }

    public void putAll(Map map) {
        Iterator i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            this.add(key, value);
        }
    }

    public V remove(K key) {
        if (this.elements == null || this.count == 0) {
            return null;
        }
        for (int i = 0; i < this.elements.length; i += 2) {
            if (this.elements[i] == null || !this.elements[i].equals(key)) continue;
            return this._remove(i);
        }
        return null;
    }

    public V remove(int index) {
        if (this.elements == null || this.count == 0) {
            return null;
        }
        return this._remove(index << 1);
    }

    protected final V _remove(int i) {
        Object result = this.elements[i + 1];
        int len = this.count * 2;
        if (i + 2 == len) {
            this.elements[i] = null;
            this.elements[i + 1] = null;
        } else {
            int k = i + 2;
            System.arraycopy(this.elements, k, this.elements, i, len - k);
        }
        --this.count;
        return (V)result;
    }

    public V get(K key) {
        if (this.elements == null || this.count == 0) {
            return null;
        }
        for (int i = 0; i < this.elements.length; i += 2) {
            if (this.elements[i] == null || !this.elements[i].equals(key)) continue;
            return (V)this.elements[i + 1];
        }
        return null;
    }

    public V get(int i) {
        if (this.elements == null || i >= this.count) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return (V)this.elements[(i << 1) + 1];
    }

    public K getKey(Object value) {
        if (this.elements == null || this.count == 0) {
            return null;
        }
        for (int i = 1; i < this.elements.length; i += 2) {
            if (this.elements[i] == null || !this.elements[i].equals(value)) continue;
            return (K)this.elements[i - 1];
        }
        return null;
    }

    public K getKey(int i) {
        if (this.elements == null || i >= this.count) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return (K)this.elements[i << 1];
    }

    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.elements == null) {
            this.elements = new Object[8];
        }
        if (this.count == 0) {
            this.elements[0] = key;
            this.elements[1] = value;
            ++this.count;
            return null;
        }
        int insertIndex = this.count * 2;
        for (int i = 0; i < insertIndex; i += 2) {
            if (!this.elements[i].equals(key)) continue;
            Object oldValue = this.elements[i + 1];
            this.elements[i + 1] = value;
            return (V)oldValue;
        }
        if (this.elements.length <= insertIndex) {
            this.grow();
        }
        this.elements[insertIndex] = key;
        this.elements[insertIndex + 1] = value;
        ++this.count;
        return null;
    }

    public void add(K key, V value) {
        int insertIndex;
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.elements == null) {
            this.elements = new Object[8];
            insertIndex = 0;
        } else {
            insertIndex = this.count * 2;
            if (this.elements.length <= insertIndex) {
                this.grow();
            }
        }
        this.elements[insertIndex] = key;
        this.elements[insertIndex + 1] = value;
        ++this.count;
    }

    public void trimToSize() {
        int len = this.count * 2;
        if (len < this.elements.length) {
            Object[] tmp = new Object[len];
            System.arraycopy(this.elements, 0, tmp, 0, len);
            this.elements = tmp;
        }
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public void clear() {
        this.elements = null;
        this.count = 0;
    }

    protected void grow() {
        Object[] expanded = new Object[this.elements.length + 10];
        System.arraycopy(this.elements, 0, expanded, 0, this.elements.length);
        this.elements = expanded;
    }

    public Object[] getArray() {
        return this.elements;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArrayMap) {
            ArrayMap map = (ArrayMap)obj;
            if (this.count != map.count) {
                return false;
            }
            int len = this.count << 1;
            for (int i = 0; i < len; i += 2) {
                Object key1 = this.elements[i];
                Object key2 = map.elements[i];
                if (!key1.equals(key2)) {
                    return false;
                }
                Object val1 = this.elements[i + 1];
                Object val2 = map.elements[i + 1];
                if (!(val1 == null ? val1 != val2 : !val1.equals(val2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        for (int i = 0; i < this.count * 2; ++i) {
            result = result * 37 + this.elements[i].hashCode();
        }
        return result;
    }
}

