/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.internals.spi.auth;

import com.google.common.net.MediaType;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.nuxeo.client.internals.util.Base64;

public class BasicAuthInterceptor
implements Interceptor {
    protected String token;

    public BasicAuthInterceptor(String username, String password) {
        this.setAuth(username, password);
    }

    public void setAuth(String username, String password) {
        String info = username + ":" + password;
        this.token = "Basic " + Base64.encode(info, 8);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request original = chain.request();
        Request request = chain.request().newBuilder().addHeader("Authorization", this.token).addHeader("Content-Type", MediaType.JSON_UTF_8.toString()).method(original.method(), original.body()).build();
        return chain.proceed(request);
    }
}

