/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.internals.spi;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class NuxeoClientException
extends RuntimeException {
    private static final int INTERNAL_ERROR_STATUS = 666;
    protected final int status;
    protected String code;
    protected final String type;
    protected final String info;
    @JsonProperty(value="stacktrace")
    protected final String exception;
    @JsonProperty(value="exception")
    protected final Throwable throwable;
    @JsonProperty(value="entity-type")
    private final String entityType;

    public NuxeoClientException(String message) {
        this(message, null);
    }

    public NuxeoClientException(Throwable e) {
        this("error", e);
    }

    public NuxeoClientException(String message, Throwable e) {
        super(message, e);
        this.throwable = e;
        this.status = 666;
        this.type = "Error";
        this.info = e == null ? null : e.getMessage();
        this.entityType = "exception";
        this.exception = message;
    }

    public NuxeoClientException(int code, String message) {
        super("An error occurred, code=" + code);
        this.info = message;
        this.throwable = null;
        this.type = null;
        this.status = code;
        this.entityType = "exception";
        this.exception = null;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public int getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getRemoteStackTrace() {
        Field[] fields = this.getClass().getDeclaredFields();
        StringBuilder result = new StringBuilder();
        for (Field field : fields) {
            try {
                if (Modifier.isPrivate(field.getModifiers()) || field.get(this) == null) continue;
                result.append("  ");
                result.append(field.getName());
                result.append(": ");
                result.append(field.get(this));
            }
            catch (IllegalAccessException ex) {
                System.out.println(ex);
            }
            result.append(System.lineSeparator());
        }
        return result.toString();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (this.status == 666) {
            super.printStackTrace(s);
        }
        s.println("Exception:");
        s.print(this.getRemoteStackTrace());
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (this.status == 666) {
            super.printStackTrace(s);
        }
        s.println("Exception:");
        s.print(this.getRemoteStackTrace());
    }

    public String getCode() {
        return this.code;
    }

    public String getException() {
        return this.exception;
    }

    public String getInfo() {
        return this.info;
    }
}

