/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.api.marshaller;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.client.api.marshaller.NuxeoMarshaller;
import org.nuxeo.client.api.objects.Document;
import org.nuxeo.client.api.objects.Documents;
import org.nuxeo.client.api.objects.RecordSet;
import org.nuxeo.client.api.objects.blob.Blob;
import org.nuxeo.client.api.objects.blob.Blobs;
import org.nuxeo.client.internals.spi.NuxeoClientException;
import org.nuxeo.client.internals.util.IOUtils;
import org.nuxeo.client.internals.util.MediaType;
import retrofit2.Converter;

public final class NuxeoResponseConverterFactory<T>
implements Converter<ResponseBody, T> {
    private static final Logger logger = LogManager.getLogger(NuxeoResponseConverterFactory.class);
    protected JavaType javaType;
    protected NuxeoMarshaller<T> nuxeoMarshaller;
    protected final ObjectMapper objectMapper;
    protected ObjectReader adapter;

    NuxeoResponseConverterFactory(ObjectReader adapter, ObjectMapper objectMapper, JavaType javaType) {
        this.adapter = adapter;
        this.objectMapper = objectMapper;
        this.javaType = javaType;
    }

    NuxeoResponseConverterFactory(NuxeoMarshaller<T> nuxeoMarshaller, ObjectMapper objectMapper) {
        this.nuxeoMarshaller = nuxeoMarshaller;
        this.objectMapper = objectMapper;
    }

    public T convert(ResponseBody value) throws IOException {
        if (this.nuxeoMarshaller != null) {
            String response = this.extractJson(value);
            logger.debug(response);
            JsonParser jsonParser = this.objectMapper.getFactory().createParser(response);
            return this.nuxeoMarshaller.read(jsonParser);
        }
        MediaType mediaType = MediaType.parse(value.contentType().toString());
        if (!(mediaType.type().equals("application") && mediaType.subtype().equals("json") || mediaType.type().equals("application") && mediaType.subtype().equals("json+nxentity"))) {
            if (mediaType.type().equals("multipart")) {
                ArrayList<Blob> blobs = new ArrayList<Blob>();
                try {
                    MimeMultipart mp = new MimeMultipart((DataSource)new ByteArrayDataSource(value.byteStream(), mediaType.toString()));
                    int size = mp.getCount();
                    for (int i = 0; i < size; ++i) {
                        BodyPart part = mp.getBodyPart(i);
                        blobs.add(new Blob(IOUtils.copyToTempFile(part.getInputStream()), part.getFileName(), part.getContentType()));
                    }
                }
                catch (MessagingException reason) {
                    throw new IOException(reason);
                }
                return (T)new Blobs(blobs);
            }
            return (T)new Blob(IOUtils.copyToTempFile(value.byteStream()));
        }
        String nuxeoEntity = mediaType.nuxeoEntity();
        if (this.javaType.getRawClass().equals(Object.class)) {
            if (nuxeoEntity != null) {
                switch (nuxeoEntity) {
                    case "document": {
                        return this.readJSON(this.extractJson(value), Document.class);
                    }
                    case "documents": {
                        return this.readJSON(this.extractJson(value), Documents.class);
                    }
                }
                return (T)value;
            }
            String response = this.extractJson(value);
            T objectResponse = this.readJSON(response, Object.class);
            if (objectResponse instanceof Map) {
                Object entityType = ((Map)objectResponse).get("entity-type");
                if (entityType != null) {
                    switch ((String)entityType) {
                        case "recordSet": {
                            return this.readJSON(response, RecordSet.class);
                        }
                    }
                    return (T)response;
                }
                return (T)response;
            }
            return (T)response;
        }
        Reader reader = value.charStream();
        try {
            Object objectResponse = this.adapter.readValue(reader);
            return (T)objectResponse;
        }
        catch (IOException reason) {
            throw new NuxeoClientException(reason);
        }
        finally {
            NuxeoResponseConverterFactory.closeQuietly(reader);
        }
    }

    protected String extractJson(ResponseBody value) throws IOException {
        String response = value.string();
        logger.debug(response);
        return response;
    }

    static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public <T> T readJSON(Reader reader, Class javaType) {
        try {
            return (T)this.objectMapper.readValue(reader, javaType);
        }
        catch (IOException reason) {
            throw new NuxeoClientException("Converter Read Issue.", reason);
        }
    }

    public <T> T readJSON(String json, Class javaType) {
        try {
            return (T)this.objectMapper.readValue(json, javaType);
        }
        catch (IOException reason) {
            throw new NuxeoClientException("Converter Read Issue.", reason);
        }
    }
}

