/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.activity;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityLinkBuilder;
import org.nuxeo.ecm.activity.ActivityReplyMessage;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.runtime.api.Framework;

public final class ActivityMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Serializable activityId;
    private final String actor;
    private final String displayActor;
    private final String displayActorLink;
    private final String verb;
    private final String message;
    private final Date publishedDate;
    private final String icon;
    private final List<ActivityReplyMessage> replies;

    @Deprecated
    public ActivityMessage(Serializable activityId, String message, Date publishedDate) {
        this(activityId, null, null, null, null, message, publishedDate, null, null);
    }

    public ActivityMessage(Serializable activityId, String actor, String displayActor, String displayActorLink, String verb, String message, Date publishedDate, String icon, List<ActivityReplyMessage> replies) {
        this.activityId = activityId;
        this.actor = actor;
        this.displayActor = displayActor;
        this.displayActorLink = displayActorLink;
        this.verb = verb;
        this.message = message;
        this.publishedDate = publishedDate;
        this.icon = icon;
        this.replies = replies;
    }

    @Deprecated
    public ActivityMessage(Activity activity, String message) {
        this(activity.getId(), activity.getActor(), activity.getDisplayActor(), null, activity.getVerb(), message, activity.getPublishedDate(), null, null);
    }

    public Serializable getActivityId() {
        return this.activityId;
    }

    public String getActor() {
        return this.actor;
    }

    public String getDisplayActor() {
        return this.displayActor;
    }

    public String getDisplayActorLink() {
        return this.displayActorLink;
    }

    public String getVerb() {
        return this.verb;
    }

    public String getMessage() {
        return this.message;
    }

    public Date getPublishedDate() {
        return this.publishedDate;
    }

    public String getIcon() {
        return this.icon;
    }

    public List<ActivityReplyMessage> getActivityReplyMessages() {
        return this.replies;
    }

    public Map<String, Object> toMap(CoreSession session, Locale locale) throws ClientException {
        return this.toMap(session, locale, null);
    }

    public Map<String, Object> toMap(CoreSession session, Locale locale, String activityLinkBuilderName) throws ClientException {
        ActivityLinkBuilder activityLinkBuilder = ((ActivityStreamService)Framework.getLocalService(ActivityStreamService.class)).getActivityLinkBuilder(activityLinkBuilderName);
        DateFormat dateFormat = DateFormat.getDateInstance(2, locale);
        HashMap<String, Object> o = new HashMap<String, Object>();
        o.put("id", this.getActivityId());
        o.put("actor", this.getActor());
        o.put("displayActor", this.getDisplayActor());
        o.put("displayActorLink", this.getDisplayActorLink());
        if (ActivityHelper.isUser(this.getActor())) {
            String actorUsername = ActivityHelper.getUsername(this.getActor());
            o.put("actorAvatarURL", activityLinkBuilder.getUserAvatarURL(session, actorUsername));
        }
        o.put("activityVerb", this.getVerb());
        o.put("activityMessage", this.getMessage());
        o.put("publishedDate", dateFormat.format(this.getPublishedDate()));
        o.put("icon", this.getIcon());
        return o;
    }
}

