/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.File;
import java.io.PrintStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.Value;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.property.Path;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrWorkspace;

public class Profiler {
    protected static final char SPACE = ' ';
    protected static final char QUOTE = '\'';
    protected static final char DOUBLE_QUOTE = '\'';
    public static final String PROFILE_FILENAME_PROPERTY_NAME = "org.modeshape.jcr.profile.filename";
    public static final String DEFAULT_FILENAME = "modeshape-profile.log";
    private static PrintStream output;
    private static final Lock lock;
    private static int counter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activated() {
        String outputFilename = System.getProperty(PROFILE_FILENAME_PROPERTY_NAME);
        if (outputFilename != null) {
            outputFilename = outputFilename.trim();
        }
        if (outputFilename == null || outputFilename.length() == 0) {
            outputFilename = DEFAULT_FILENAME;
        }
        if (outputFilename.endsWith("/")) {
            outputFilename = outputFilename + DEFAULT_FILENAME;
        }
        try {
            lock.lock();
            File outputFile = null;
            while ((outputFile = new File(outputFilename + '.' + StringUtil.justifyRight((String)Integer.toString(++counter), (int)3, (char)'0'))).exists()) {
            }
            assert (outputFile != null);
            assert (!outputFile.exists());
            System.out.println("Writing profile output to " + outputFile.getAbsolutePath());
            File parent = outputFile.getParentFile();
            if (parent != null) {
                parent.mkdirs();
                assert (parent.canWrite());
            }
            output = new PrintStream(outputFile);
        }
        catch (Throwable e) {
            e.printStackTrace();
            output = System.out;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deactivated() {
        output.flush();
        if (output != System.out) {
            try {
                lock.lock();
                output.close();
            }
            finally {
                output = null;
                lock.unlock();
            }
        }
    }

    public void enterMethod(String methodName, Object[] targetAndParams) {
        this.writeMethodOnLine("ENTER", null, methodName, targetAndParams);
    }

    public void exitMethod(String methodName, Object[] targetAndParams) {
        this.writeMethodOnLine("EXIT", null, methodName, targetAndParams);
    }

    public void traceMethod(String methodName, Object[] targetAndParams) {
        this.writeMethodOnLine(null, null, methodName, targetAndParams);
    }

    public void enterMethod(Object target, String methodName, Object ... params) {
        this.writeMethodOnLine("ENTER", target, methodName, params);
    }

    public void exitMethod(Object target, String methodName, Object ... params) {
        this.writeMethodOnLine("EXIT", target, methodName, params);
    }

    public void traceMethod(Object target, String methodName, Object ... params) {
        this.writeMethodOnLine(null, target, methodName, params);
    }

    public void trace(String action, Object ... params) {
        this.writeMethodOnLine(action, null, null, params);
    }

    public void trace(String action) {
        this.writeMethodOnLine(action, null, null, new Object[0]);
    }

    public void traceMessage(String message) {
        this.writeOnLine(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeOnLine(String message) {
        try {
            lock.lock();
            output.print(message);
            output.println();
        }
        catch (Throwable t) {
            t.printStackTrace(output);
        }
        finally {
            lock.unlock();
        }
    }

    protected final void writeMethodOnLine(String action, Object target, String methodName, Object ... params) {
        this.writeMethod(true, action, target, methodName, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeMethod(boolean appendNewline, String action, Object target, String methodName, Object ... params) {
        try {
            lock.lock();
            output.print(Profiler.now());
            output.append(' ');
            output.print(Thread.currentThread().getId());
            output.append(' ');
            if (action != null) {
                output.print(action);
                output.append(' ');
            }
            int i = 0;
            if (target == null && params.length > 0) {
                target = params[0];
                i = 1;
            }
            if (target != null) {
                output.print(target.getClass().getName());
                output.append('.');
            }
            if (methodName != null) {
                output.print(methodName);
                output.append('(');
            }
            boolean first = true;
            int maxIndex = params.length;
            while (i != maxIndex) {
                Object value = params[i];
                if (first) {
                    first = false;
                } else {
                    output.print(',');
                }
                this.write(value);
                ++i;
            }
            if (methodName != null) {
                output.append(')');
            }
            if (target != null) {
                output.append(" on ");
                this.write(target);
            }
            output.println();
        }
        catch (Throwable t) {
            t.printStackTrace(output);
        }
        finally {
            lock.unlock();
        }
    }

    protected final void write(Object value) throws Exception {
        if (value instanceof String) {
            output.print('\'');
            output.append(value.toString());
            output.print('\'');
        } else if (value instanceof Path) {
            output.print('\'');
            output.append(value.toString());
            output.print('\'');
        } else if (value instanceof Value) {
            Value v = (Value)value;
            switch (v.getType()) {
                case 1: {
                    output.print('\'');
                    output.append(v.toString());
                    output.print('\'');
                    break;
                }
                case 8: {
                    output.print('\'');
                    output.append(v.toString());
                    output.print('\'');
                    break;
                }
                case 2: {
                    output.append(v.getBinary().toString());
                    break;
                }
                default: {
                    output.append(v.toString());
                    break;
                }
            }
        } else if (value instanceof JcrSession) {
            output.print("Session ");
            output.append(((JcrSession)value).sessionId());
        } else if (value instanceof JcrWorkspace) {
            output.print("Workspace ");
            output.append(((JcrWorkspace)value).getName());
        } else {
            output.print(value);
        }
    }

    protected static final long now() {
        return System.nanoTime();
    }

    static {
        lock = new ReentrantLock();
        counter = 0;
    }
}

