/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import org.jbpm.workflow.core.impl.NodeImpl;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.NodeType;

public class Join
extends NodeImpl {
    public static final int TYPE_UNDEFINED = 0;
    public static final int TYPE_AND = 1;
    public static final int TYPE_XOR = 2;
    public static final int TYPE_DISCRIMINATOR = 3;
    public static final int TYPE_N_OF_M = 4;
    public static final int TYPE_OR = 5;
    private static final long serialVersionUID = 510L;
    private int type = 0;
    private String n;

    public Join() {
        super(NodeType.COMPLEX_GATEWAY);
    }

    public void setType(int type) {
        this.type = type;
        this.setNodeType(Join.fromType(type));
    }

    private static NodeType fromType(int type) {
        switch (type) {
            case 1: {
                return NodeType.PARALLEL_GATEWAY;
            }
            case 5: {
                return NodeType.INCLUSIVE_GATEWAY;
            }
            case 2: {
                return NodeType.EXCLUSIVE_GATEWAY;
            }
        }
        return NodeType.COMPLEX_GATEWAY;
    }

    public int getType() {
        return this.type;
    }

    public void setN(String n) {
        this.n = n;
    }

    public String getN() {
        return this.n;
    }

    @Override
    public void validateAddIncomingConnection(String type, Connection connection) {
        super.validateAddIncomingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node [" + connection.getTo().getMetaData().get("UniqueId") + ", " + connection.getTo().getName() + "] only accepts default incoming connection type!");
        }
    }

    @Override
    public void validateAddOutgoingConnection(String type, Connection connection) {
        super.validateAddOutgoingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node [" + connection.getFrom().getMetaData().get("UniqueId") + ", " + connection.getFrom().getName() + "] only accepts default outgoing connection type!");
        }
        if (this.getTo() != null) {
            throw new IllegalArgumentException("This type of node [" + connection.getFrom().getMetaData().get("UniqueId") + ", " + connection.getFrom().getName() + "] cannot have more than one outgoing connection!");
        }
    }
}

