/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectCloner {
    private static Map<Class<?>, UnaryOperator<Object>> constructorExecutorMap = Collections.synchronizedMap(new WeakHashMap());
    private static Collection<Class<?>> unmutableClasses = ConcurrentHashMap.newKeySet();
    private static UnaryOperator<Object> identity = t -> t;
    private static final Logger logger = LoggerFactory.getLogger(ObjectCloner.class);

    private ObjectCloner() {
    }

    public static Object clone(Object object) {
        return ObjectCloner.clone(object, new Config());
    }

    public static Object clone(Object object, Config config) {
        Object result = object == null || object instanceof Boolean || object instanceof Number || object instanceof CharSequence || object instanceof Enum ? object : (object.getClass().isArray() ? ObjectCloner.cloneArray(object) : (object instanceof Collection ? ObjectCloner.cloneCollection((Collection)object, config) : (object instanceof Map ? ObjectCloner.cloneMap((Map)object, config) : ObjectCloner.cloneObject(object))));
        return result;
    }

    private static Object cloneArray(Object array) {
        int size = Array.getLength(array);
        Object result = Array.newInstance(array.getClass().getComponentType(), size);
        System.arraycopy(array, 0, result, 0, size);
        return result;
    }

    private static Object cloneCollection(Collection<?> collection, Config config) {
        if (collection.isEmpty()) {
            return collection;
        }
        return config.deepCloneCollections ? ObjectCloner.deepCloneCollection(collection) : ObjectCloner.lightCloneCollectionMap(collection, Collection.class);
    }

    private static Collection deepCloneCollection(Collection<?> object) {
        Collection<Object> result = null;
        Optional<Constructor<?>> constructor = ObjectCloner.getCollectionConstructor(object.getClass(), new Class[0]);
        if (constructor.isPresent()) {
            try {
                result = (Collection)constructor.get().newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                logger.warn("Unexpected exception invoking default constructor of type {}", object.getClass());
            }
        }
        if (result == null) {
            result = new ArrayList();
        }
        for (Object item : object) {
            result.add(ObjectCloner.clone(item));
        }
        return result;
    }

    private static Object cloneMap(Map<?, ?> map, Config config) {
        if (map.isEmpty()) {
            return map;
        }
        return config.deepCloneCollections ? ObjectCloner.deepCloneMap(map) : ObjectCloner.lightCloneCollectionMap(map, Map.class);
    }

    private static Map deepCloneMap(Map<?, ?> object) {
        Map<?, Object> result = null;
        Optional<Constructor<?>> constructor = ObjectCloner.getCollectionConstructor(object.getClass(), new Class[0]);
        if (constructor.isPresent()) {
            try {
                result = (Map)constructor.get().newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                logger.warn("Unexpected exception invoking default constructor of type {}", object.getClass());
            }
        }
        if (result == null) {
            result = new HashMap();
        }
        for (Map.Entry<?, ?> item : object.entrySet()) {
            result.put(item.getKey(), ObjectCloner.clone(item.getValue()));
        }
        return result;
    }

    private static Object lightCloneCollectionMap(Object object, Class<?> paramType) {
        return ObjectCloner.getCollectionConstructor(object.getClass(), paramType).map(c -> {
            try {
                return c.newInstance(object);
            }
            catch (ReflectiveOperationException e) {
                logger.warn("Unexpected exception invoking constructor {} with object {}", c, object);
                return object;
            }
        }).orElse(object);
    }

    private static <T> Optional<Constructor<?>> getCollectionConstructor(Class<?> collectionClass, Class<?> ... paramTypes) {
        if (unmutableClasses.contains(collectionClass)) {
            return Optional.empty();
        }
        try {
            return Optional.of(collectionClass.getConstructor(paramTypes));
        }
        catch (NoSuchMethodException ex) {
            logger.debug("Copy constructor not found for type {}", collectionClass, (Object)ex);
            unmutableClasses.add(collectionClass);
            return Optional.empty();
        }
    }

    private static Object cloneObject(Object object) {
        Class<?> objectClass = object.getClass();
        if (object instanceof Cloneable) {
            try {
                return objectClass.getMethod("clone", new Class[0]).invoke(object, new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                logger.warn("Failing to call clone in a cloneable object!!", (Throwable)ex);
                return object;
            }
        }
        return ObjectCloner.cloneWithConstructor(object, objectClass);
    }

    private static Object cloneWithConstructor(Object object, Class<?> objectClass) {
        return constructorExecutorMap.computeIfAbsent(objectClass, ObjectCloner::getConstructorExecutor).apply(object);
    }

    private static UnaryOperator<Object> getConstructorExecutor(Class<?> objectClass) {
        UnaryOperator<Object> result;
        ConstructorInfo constructorInfo = new ConstructorInfo(objectClass);
        UnaryOperator<Object> unaryOperator = result = constructorInfo.getCopyConstructor() != null ? new CopyConstructorExecutor(constructorInfo.getCopyConstructor()) : ObjectCloner.getConstructorExecutor(objectClass, constructorInfo);
        if (result == null) {
            logger.info("No suitable constructor found for type {}", objectClass);
            return identity;
        }
        return result;
    }

    private static boolean inmutable(MethodInfo classInfo) {
        return classInfo.getMatchingMethods().isEmpty() && classInfo.getFields().isEmpty();
    }

    private static UnaryOperator<Object> getConstructorExecutor(Class<?> objectClass, ConstructorInfo constructorInfo) {
        MethodInfo methodInfo = new MethodInfo(objectClass);
        if (ObjectCloner.inmutable(methodInfo)) {
            logger.debug("Inmutable object type {}", objectClass);
            return identity;
        }
        for (Constructor<?> constructor : constructorInfo.getOtherConstructors()) {
            Class<?>[] parameters = constructor.getParameterTypes();
            ArrayList<ArgResolver> args = new ArrayList<ArgResolver>();
            boolean found = true;
            for (int i = 0; found && i < parameters.length; ++i) {
                ArgResolver arg = ObjectCloner.getArg(parameters[i], methodInfo);
                boolean bl = found = arg != null;
                if (!found) continue;
                args.add(arg);
            }
            if (!found) continue;
            return new ArgsConstructorExecutor(constructor, args, methodInfo);
        }
        return constructorInfo.getDefaultConstructor() != null ? new DefaultConstructorExecutor(constructorInfo.getDefaultConstructor(), methodInfo) : null;
    }

    private static ArgResolver getArg(Class<?> parameterType, MethodInfo classInfo) {
        for (Method m : classInfo.getMissingGetterMethods()) {
            if (!parameterType.isAssignableFrom(m.getReturnType())) continue;
            return x$0 -> m.invoke(x$0, new Object[0]);
        }
        for (Method m : classInfo.getMatchingMethods().values()) {
            if (!parameterType.isAssignableFrom(m.getReturnType())) continue;
            return x$0 -> m.invoke(x$0, new Object[0]);
        }
        for (Field f : classInfo.getFields()) {
            if (!parameterType.isAssignableFrom(f.getType())) continue;
            return f::get;
        }
        return null;
    }

    @FunctionalInterface
    private static interface ArgResolver {
        public Object apply(Object var1) throws ReflectiveOperationException;
    }

    private static class ArgsConstructorExecutor
    extends MatcherConstructorExecutor {
        private Collection<ArgResolver> argResolvers;

        public ArgsConstructorExecutor(Constructor<?> constructor, Collection<ArgResolver> argResolvers, MethodInfo methodInfo) {
            super(constructor, methodInfo);
            this.argResolvers = argResolvers;
        }

        @Override
        protected Object[] args(Object object) throws ReflectiveOperationException {
            Object[] args = new Object[this.argResolvers.size()];
            int i = 0;
            for (ArgResolver argResolver : this.argResolvers) {
                args[i++] = ObjectCloner.clone(argResolver.apply(object));
            }
            return args;
        }
    }

    private static class DefaultConstructorExecutor
    extends MatcherConstructorExecutor {
        public DefaultConstructorExecutor(Constructor<?> constructor, MethodInfo methodInfo) {
            super(constructor, methodInfo);
        }

        @Override
        protected Object[] args(Object object) {
            return new Object[0];
        }
    }

    private static abstract class MatcherConstructorExecutor
    extends ConstructorExecutor {
        private final Map<Method, Method> matchingMethods;
        private final Collection<Field> fields;

        public MatcherConstructorExecutor(Constructor<?> constructor, MethodInfo methodInfo) {
            super(constructor);
            this.matchingMethods = methodInfo.getMatchingMethods();
            this.fields = methodInfo.getFields();
        }

        @Override
        protected void postConstruct(Object src, Object dest) throws ReflectiveOperationException {
            for (Map.Entry<Method, Method> entry : this.matchingMethods.entrySet()) {
                entry.getKey().invoke(dest, ObjectCloner.clone(entry.getValue().invoke(src, new Object[0])));
            }
            for (Field field : this.fields) {
                field.set(dest, ObjectCloner.clone(field.get(src)));
            }
        }
    }

    private static class CopyConstructorExecutor
    extends ConstructorExecutor {
        public CopyConstructorExecutor(Constructor<?> constructor) {
            super(constructor);
        }

        @Override
        protected Object[] args(Object object) {
            return new Object[]{object};
        }
    }

    private static abstract class ConstructorExecutor
    implements UnaryOperator<Object> {
        private Constructor<?> constructor;

        public ConstructorExecutor(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public Object apply(Object object) {
            try {
                Object result = this.constructor.newInstance(this.args(object));
                this.postConstruct(object, result);
                return result;
            }
            catch (ReflectiveOperationException e) {
                logger.error("Introspection error while cloning object {} of type {}", new Object[]{object, object.getClass(), e});
                return object;
            }
        }

        protected abstract Object[] args(Object var1) throws ReflectiveOperationException;

        protected void postConstruct(Object src, Object dest) throws ReflectiveOperationException {
        }
    }

    private static class MethodInfo {
        private static final Set<String> excluded = new HashSet<String>(Arrays.asList("equals", "toString", "wait", "getClass", "hashCode"));
        private Map<Method, Method> matchingMethods = new HashMap<Method, Method>();
        private Collection<Field> fields = new ArrayList<Field>();
        private Collection<Method> missingGetterMethods = new ArrayList<Method>();

        public MethodInfo(Class<?> objectClass) {
            Field[] classFields;
            Method[] methods = objectClass.getMethods();
            boolean[] alreadyPaired = new boolean[methods.length];
            for (int i = 0; i < methods.length; ++i) {
                Method method;
                MemberType memberType;
                if (alreadyPaired[i] || (memberType = MethodInfo.getType(method = methods[i])) == MemberType.OTHER) continue;
                boolean found = false;
                for (int j = i + 1; !found && j < methods.length; ++j) {
                    if (alreadyPaired[j] || !(found = this.isMatch(method, memberType, methods[j]))) continue;
                    alreadyPaired[j] = true;
                    this.addMatchMethod(method, memberType, methods[j]);
                }
                if (found) continue;
                this.addMissingMethod(methods[i], memberType);
            }
            for (Field field : classFields = objectClass.getFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                this.fields.add(field);
            }
        }

        private static MemberType getType(Method method) {
            boolean isVoid = method.getReturnType().equals(Void.TYPE);
            int count = method.getParameterCount();
            if (!isVoid && count == 0 && !excluded.contains(method.getName())) {
                return MemberType.GET;
            }
            if (isVoid && count == 1 && !excluded.contains(method.getName())) {
                return MemberType.SET;
            }
            return MemberType.OTHER;
        }

        private void addMatchMethod(Method method, MemberType memberType, Method match) {
            if (memberType == MemberType.SET) {
                this.matchingMethods.put(method, match);
            } else {
                this.matchingMethods.put(match, method);
            }
        }

        private void addMissingMethod(Method method, MemberType type) {
            if (type == MemberType.GET) {
                this.missingGetterMethods.add(method);
            }
        }

        private boolean isMatch(Method input, MemberType memberType, Method potential) {
            MemberType potentialType = MethodInfo.getType(potential);
            return memberType == MemberType.GET && potentialType == MemberType.SET && input.getReturnType().equals(potential.getParameterTypes()[0]) && this.matchingNames(input.getName().replace("get", ""), potential.getName().replace("set", "")) || memberType == MemberType.SET && potentialType == MemberType.GET && input.getParameterTypes()[0].equals(potential.getReturnType()) && this.matchingNames(input.getName().replace("set", ""), potential.getName().replace("get", ""));
        }

        private boolean matchingNames(String name, String candidate) {
            return name.equals(candidate);
        }

        public Map<Method, Method> getMatchingMethods() {
            return this.matchingMethods;
        }

        public Collection<Field> getFields() {
            return this.fields;
        }

        public Collection<Method> getMissingGetterMethods() {
            return this.missingGetterMethods;
        }

        private static enum MemberType {
            SET,
            GET,
            OTHER;

        }
    }

    private static class ConstructorInfo {
        private Collection<Constructor<?>> otherConstructors = new ArrayList();
        private Constructor<?> defaultConstructor;
        private Constructor<?> copyConstructor;

        public ConstructorInfo(Class<?> objectClass) {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = objectClass.getConstructors()) {
                if (constructor.getParameterCount() == 0) {
                    this.defaultConstructor = constructor;
                    continue;
                }
                if (constructor.getParameterCount() == 1 && constructor.getParameterTypes()[0].isAssignableFrom(objectClass)) {
                    this.copyConstructor = constructor;
                    break;
                }
                this.otherConstructors.add(constructor);
            }
        }

        public Collection<Constructor<?>> getOtherConstructors() {
            return this.otherConstructors;
        }

        public Constructor<?> getDefaultConstructor() {
            return this.defaultConstructor;
        }

        public Constructor<?> getCopyConstructor() {
            return this.copyConstructor;
        }
    }

    public static class Config {
        private boolean deepCloneCollections = true;

        public Config deepCloneCollections(boolean deepCloneCollections) {
            this.deepCloneCollections = deepCloneCollections;
            return this;
        }

        public boolean isDeepCloneCollections() {
            return this.deepCloneCollections;
        }
    }
}

