/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory;

import java.util.ArrayList;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.ruleflow.core.factory.DialectConverter;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.kie.api.fluent.Dialect;
import org.kie.api.fluent.MilestoneNodeBuilder;
import org.kie.api.fluent.NodeContainerBuilder;

public class MilestoneNodeFactory<T extends NodeContainerBuilder<T, ?>>
extends NodeFactory<MilestoneNodeBuilder<T>, T>
implements MilestoneNodeBuilder<T> {
    public MilestoneNodeFactory(T nodeContainerFactory, NodeContainer nodeContainer, long id) {
        super(nodeContainerFactory, nodeContainer, new MilestoneNode(), id);
    }

    protected MilestoneNode getMilestoneNode() {
        return (MilestoneNode)this.getNode();
    }

    public MilestoneNodeFactory<T> onEntryAction(String dialect, String action) {
        if (this.getMilestoneNode().getActions(dialect) != null) {
            this.getMilestoneNode().getActions(dialect).add(new DroolsConsequenceAction(dialect, action));
        } else {
            ArrayList<DroolsAction> actions = new ArrayList<DroolsAction>();
            actions.add(new DroolsConsequenceAction(dialect, action));
            this.getMilestoneNode().setActions("onEntry", actions);
        }
        return this;
    }

    public MilestoneNodeFactory<T> onExitAction(String dialect, String action) {
        if (this.getMilestoneNode().getActions(dialect) != null) {
            this.getMilestoneNode().getActions(dialect).add(new DroolsConsequenceAction(dialect, action));
        } else {
            ArrayList<DroolsAction> actions = new ArrayList<DroolsAction>();
            actions.add(new DroolsConsequenceAction(dialect, action));
            this.getMilestoneNode().setActions("onExit", actions);
        }
        return this;
    }

    public MilestoneNodeFactory<T> constraint(String constraint) {
        this.getMilestoneNode().setConstraint(constraint);
        return this;
    }

    public MilestoneNodeFactory<T> timer(String delay, String period, String dialect, String action) {
        Timer timer = new Timer();
        timer.setDelay(delay);
        timer.setPeriod(period);
        this.getMilestoneNode().addTimer(timer, new DroolsConsequenceAction(dialect, action));
        return this;
    }

    public MilestoneNodeBuilder<T> onEntryAction(Dialect dialect, String action) {
        return this.onEntryAction(DialectConverter.fromDialect(dialect), action);
    }

    public MilestoneNodeBuilder<T> onExitAction(Dialect dialect, String action) {
        return this.onExitAction(DialectConverter.fromDialect(dialect), action);
    }

    public MilestoneNodeBuilder<T> timer(String delay, String period, Dialect dialect, String action) {
        return this.timer(delay, period, DialectConverter.fromDialect(dialect), action);
    }
}

