/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.core.util;

import java.util.HashMap;
import java.util.Map;

public class WorkItemHeaderInfo {
    private final String name;
    private final Object content;
    private final Map<String, Object> params;

    private WorkItemHeaderInfo(String name, Object content, Map<String, Object> params) {
        this.name = name;
        this.content = content;
        this.params = params;
    }

    public String getName() {
        return this.name;
    }

    public Object getContent() {
        return this.content;
    }

    public Object getParam(String key) {
        return this.params.get(key);
    }

    public String toString() {
        return "WorkItemHeaderInfo [name=" + this.name + ", content=" + this.content + ", params=" + this.params + "]";
    }

    public static class Builder {
        private final String name;
        private Object content;
        private Map<String, Object> parameters;

        private Builder(String name) {
            this.name = name;
            this.parameters = new HashMap<String, Object>();
        }

        public static Builder of(String name) {
            return new Builder(name);
        }

        public Builder withContent(Object content) {
            this.content = content;
            return this;
        }

        public Builder withParam(String key, Object value) {
            this.parameters.put(key, value);
            return this;
        }

        public WorkItemHeaderInfo build() {
            return new WorkItemHeaderInfo(this.name, this.content, this.parameters);
        }
    }
}

