/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.core.util;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.service.WidService;

public class WidInfo {
    private String widfile;
    private String name;
    private String displayName;
    private String category;
    private String icon;
    private String description;
    private String defaultHandler;
    private String defaultHandlerNoType;
    private String defaultHandlerUnEscaped;
    private String defaultHandlerNoTypeUnEscaped;
    private String documentation;
    private Map<String, InternalWidParamsAndResults> parameters = new HashMap<String, InternalWidParamsAndResults>();
    private Map<String, InternalWidParameterValues> parameterValues = new HashMap<String, InternalWidParameterValues>();
    private Map<String, InternalWidParamsAndResults> results = new HashMap<String, InternalWidParamsAndResults>();
    private Map<String, InternalWidMavenDependencies> mavenDepends = new HashMap<String, InternalWidMavenDependencies>();
    private InternalServiceInfo serviceInfo;

    public WidInfo(List<Wid> wids) {
        for (Wid wid : wids) {
            this.widfile = this.setParamValue(this.widfile, wid.widfile());
            this.name = this.setParamValue(this.name, wid.name());
            this.displayName = this.setParamValue(this.displayName, wid.displayName());
            this.category = this.setParamValue(this.category, wid.category());
            this.icon = this.setParamValue(this.icon, wid.icon());
            this.description = this.setParamValue(this.description, wid.description());
            this.defaultHandler = this.setParamValue(this.defaultHandler, wid.defaultHandler().replaceAll("\"", "\\\\\""));
            this.defaultHandlerNoType = this.removeType(this.setParamValue(this.defaultHandler, wid.defaultHandler().replaceAll("\"", "\\\\\"")));
            this.defaultHandlerUnEscaped = wid.defaultHandler();
            this.defaultHandlerNoTypeUnEscaped = this.removeType(this.setParamValue(this.defaultHandler, wid.defaultHandler()));
            this.documentation = this.setParamValue(this.documentation, wid.documentation());
            if (wid.parameters().length > 0) {
                for (Annotation annotation : wid.parameters()) {
                    this.parameters.put(annotation.name(), new InternalWidParamsAndResults(annotation.name(), annotation.type(), annotation.runtimeType(), annotation.required()));
                }
            }
            if (wid.parameterValues().length > 0) {
                for (Annotation annotation : wid.parameterValues()) {
                    this.parameterValues.put(annotation.parameterName(), new InternalWidParameterValues(annotation.parameterName(), annotation.values()));
                }
            }
            if (wid.results().length > 0) {
                for (Annotation annotation : wid.results()) {
                    this.results.put(annotation.name(), new InternalWidParamsAndResults(annotation.name(), annotation.type(), annotation.runtimeType(), false));
                }
            }
            if (wid.mavenDepends().length > 0) {
                for (Annotation annotation : wid.mavenDepends()) {
                    this.mavenDepends.put(annotation.group() + "." + annotation.artifact(), new InternalWidMavenDependencies(annotation.group(), annotation.artifact(), annotation.version()));
                }
            }
            this.serviceInfo = new InternalServiceInfo(wid.serviceInfo());
        }
    }

    private String setParamValue(String origVal, String newVal) {
        if (newVal != null && !newVal.isEmpty()) {
            return newVal;
        }
        return origVal == null || origVal.isEmpty() ? "" : origVal;
    }

    private String removeType(String value) {
        if (value != null) {
            if (value.startsWith("mvel: ")) {
                return value.substring(6);
            }
            if (value.startsWith("reflection: ")) {
                return value.substring(12);
            }
            return value;
        }
        return value;
    }

    public String getWidfile() {
        return this.widfile;
    }

    public void setWidfile(String widfile) {
        this.widfile = widfile;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefaultHandler() {
        return this.defaultHandler;
    }

    public void setDefaultHandler(String defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public String getDefaultHandlerNoType() {
        return this.defaultHandlerNoType;
    }

    public void setDefaultHandlerNoType(String defaultHandlerNoType) {
        this.defaultHandlerNoType = defaultHandlerNoType;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public Map<String, InternalWidParamsAndResults> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, InternalWidParamsAndResults> parameters) {
        this.parameters = parameters;
    }

    public Map<String, InternalWidParameterValues> getParameterValues() {
        return this.parameterValues;
    }

    public void setParameterValues(Map<String, InternalWidParameterValues> parameterValues) {
        this.parameterValues = parameterValues;
    }

    public Map<String, InternalWidParamsAndResults> getResults() {
        return this.results;
    }

    public void setResults(Map<String, InternalWidParamsAndResults> results) {
        this.results = results;
    }

    public Map<String, InternalWidMavenDependencies> getMavenDepends() {
        return this.mavenDepends;
    }

    public void setMavenDepends(Map<String, InternalWidMavenDependencies> mavenDepends) {
        this.mavenDepends = mavenDepends;
    }

    public InternalServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public void setServiceInfo(InternalServiceInfo serviceInfo) {
        this.serviceInfo = serviceInfo;
    }

    public String getDefaultHandlerUnEscaped() {
        return this.defaultHandlerUnEscaped;
    }

    public void setDefaultHandlerUnEscaped(String defaultHandlerUnEscaped) {
        this.defaultHandlerUnEscaped = defaultHandlerUnEscaped;
    }

    public String getDefaultHandlerNoTypeUnEscaped() {
        return this.defaultHandlerNoTypeUnEscaped;
    }

    public void setDefaultHandlerNoTypeUnEscaped(String defaultHandlerNoTypeUnEscaped) {
        this.defaultHandlerNoTypeUnEscaped = defaultHandlerNoTypeUnEscaped;
    }

    public class InternalServiceAuth {
        private boolean required;
        private String[] params;
        private String[] paramsDescription;
        private String description;
        private String referencesite;

        public InternalServiceAuth(boolean required, String[] params, String[] paramsDescription, String description, String referencesite) {
            this.required = required;
            this.params = params;
            this.paramsDescription = paramsDescription;
            this.description = description;
            this.referencesite = referencesite;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public String[] getParams() {
            return this.params;
        }

        public void setParams(String[] params) {
            this.params = params;
        }

        public String[] getParamsDescription() {
            return this.paramsDescription;
        }

        public void setParamsDescription(String[] paramsDescription) {
            this.paramsDescription = paramsDescription;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getReferencesite() {
            return this.referencesite;
        }

        public void setReferencesite(String referencesite) {
            this.referencesite = referencesite;
        }
    }

    public class InternalServiceAction {
        private String title;
        private String description;
        private boolean requiredFieldsOnly;

        public InternalServiceAction(String title, String description, boolean requiredFieldsOnly) {
            this.title = title;
            this.description = description;
            this.requiredFieldsOnly = requiredFieldsOnly;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isRequiredFieldsOnly() {
            return this.requiredFieldsOnly;
        }

        public void setRequiredFieldsOnly(boolean requiredFieldsOnly) {
            this.requiredFieldsOnly = requiredFieldsOnly;
        }
    }

    public class InternalServiceTrigger {
        private String title;
        private String description;

        public InternalServiceTrigger(String title, String description) {
            this.title = title;
            this.description = description;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    public class InternalServiceInfo {
        private boolean hasTrigger;
        private boolean hasAction;
        private String category;
        private List<String> keywords;
        private String description;
        private InternalServiceTrigger trigger;
        private InternalServiceAction action;
        private InternalServiceAuth authInfo;

        public InternalServiceInfo(WidService service) {
            if (service.category().length() > 0 && service.description().length() > 0) {
                this.category = service.category();
                this.description = service.description();
                this.keywords = Arrays.asList(service.keywords().split("\\s*,\\s*"));
                if (service.trigger().title().length() > 0) {
                    this.hasTrigger = true;
                    this.trigger = new InternalServiceTrigger(service.trigger().title(), service.trigger().description());
                }
                if (service.action().title().length() > 0) {
                    this.hasAction = true;
                    this.action = new InternalServiceAction(service.action().title(), service.action().description(), service.action().requiredFieldsOnly());
                }
            } else {
                this.hasTrigger = false;
                this.hasAction = false;
            }
            this.authInfo = new InternalServiceAuth(service.authinfo().required(), service.authinfo().params(), service.authinfo().paramsdescription(), service.authinfo().description(), service.authinfo().referencesite());
        }

        public boolean isHasTrigger() {
            return this.hasTrigger;
        }

        public void setHasTrigger(boolean hasTrigger) {
            this.hasTrigger = hasTrigger;
        }

        public boolean isHasAction() {
            return this.hasAction;
        }

        public void setHasAction(boolean hasAction) {
            this.hasAction = hasAction;
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public List<String> getKeywords() {
            return this.keywords;
        }

        public void setKeywords(List<String> keywords) {
            this.keywords = keywords;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public InternalServiceTrigger getTrigger() {
            return this.trigger;
        }

        public void setTrigger(InternalServiceTrigger trigger) {
            this.trigger = trigger;
        }

        public InternalServiceAction getAction() {
            return this.action;
        }

        public void setAction(InternalServiceAction action) {
            this.action = action;
        }

        public InternalServiceAuth getAuthInfo() {
            return this.authInfo;
        }

        public void setAuthInfo(InternalServiceAuth authInfo) {
            this.authInfo = authInfo;
        }
    }

    public class InternalWidMavenDependencies {
        private String group;
        private String artifact;
        private String version;

        public InternalWidMavenDependencies(String group, String artifact, String version) {
            this.group = group;
            this.artifact = artifact;
            this.version = version;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getArtifact() {
            return this.artifact;
        }

        public void setArtifact(String artifact) {
            this.artifact = artifact;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }

    private class InternalWidParameterValues {
        private String parameterName;
        private String values;

        public InternalWidParameterValues(String parameterName, String values) {
            this.parameterName = parameterName;
            this.values = values;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public String getValues() {
            return this.values;
        }

        public void setValues(String values) {
            this.values = values;
        }
    }

    private class InternalWidParamsAndResults {
        private String name;
        private String type;
        private String runtimeType;
        private boolean required;

        public InternalWidParamsAndResults(String name, String type, String runtimeType, boolean required) {
            this.name = name;
            this.type = type;
            this.runtimeType = runtimeType;
            this.required = required;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getRuntimeType() {
            return this.runtimeType;
        }

        public void setRuntimeType(String runtimeType) {
            this.runtimeType = runtimeType;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }
    }
}

