/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunit.executor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.core.SessionConfiguration;
import org.drools.core.SessionConfigurationImpl;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.spi.Activation;
import org.drools.core.spi.FactHandleFactory;
import org.drools.ruleunit.DataSource;
import org.drools.ruleunit.RuleUnit;
import org.drools.ruleunit.RuleUnitExecutor;
import org.drools.ruleunit.datasources.CursoredDataSource;
import org.drools.ruleunit.datasources.InternalDataSource;
import org.drools.ruleunit.executor.InternalRuleUnitExecutor;
import org.drools.ruleunit.executor.RuleUnitSessionImpl;
import org.drools.ruleunit.impl.RuleUnitDescriptionImpl;
import org.drools.ruleunit.impl.RuleUnitFactory;
import org.drools.ruleunit.impl.RuleUnitGuardSystem;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;

public class RuleUnitExecutorSession
implements InternalRuleUnitExecutor {
    private final RuleUnitSessionImpl session;
    private final Map<Class<?>, FactHandle> factHandlesMap = new HashMap();
    private RuleUnitGuardSystem ruleUnitGuardSystem;
    private RuleUnitFactory ruleUnitFactory;
    private RuleUnit currentRuleUnit;
    private RuleUnitDescriptionImpl currentRuDescr;
    private AtomicBoolean suspended = new AtomicBoolean(false);
    private LinkedList<RuleUnit> unitsStack = new LinkedList();

    public RuleUnitExecutorSession() {
        this.session = new RuleUnitSessionImpl(this, new StatefulKnowledgeSessionImpl());
        this.initSession((SessionConfiguration)new SessionConfigurationImpl(), EnvironmentFactory.newEnvironment());
        this.session.initEventSupports();
    }

    public RuleUnitExecutorSession(KieBase kiebase) {
        this.session = new RuleUnitSessionImpl(this, (StatefulKnowledgeSessionImpl)kiebase.newKieSession());
        this.session.ruleUnitExecutor = this;
        this.ruleUnitGuardSystem = new RuleUnitGuardSystem(this);
    }

    public RuleUnitExecutorSession(KieSession session) {
        this.session = new RuleUnitSessionImpl(this, (StatefulKnowledgeSessionImpl)session);
        this.session.ruleUnitExecutor = this;
        this.bind(session.getKieBase());
    }

    public RuleUnitExecutorSession(long id, boolean initInitFactHandle, SessionConfiguration config, Environment environment) {
        this.session = new RuleUnitSessionImpl(this, new StatefulKnowledgeSessionImpl(id, null, initInitFactHandle, config, environment));
        this.initSession(config, environment);
    }

    public RuleUnitExecutorSession(long id, FactHandleFactory handleFactory, long propagationContext, SessionConfiguration config, InternalAgenda agenda, Environment environment) {
        this.session = new RuleUnitSessionImpl(this, new StatefulKnowledgeSessionImpl(id, null, handleFactory, propagationContext, config, agenda, environment));
        this.initSession(config, environment);
    }

    private void initSession(SessionConfiguration config, Environment environment) {
        this.session.init(config, environment);
        this.session.ruleUnitExecutor = this;
    }

    @Override
    public RuleUnitExecutor bind(KieBase kiebase) {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)kiebase;
        if (!kbase.hasUnits()) {
            throw new IllegalStateException("Cannot create a RuleUnitExecutor against a KieBase without units");
        }
        this.session.setHandleFactory(kbase.newFactHandleFactory());
        this.session.bindRuleBase(kbase, null, false);
        this.ruleUnitGuardSystem = new RuleUnitGuardSystem(this);
        return this;
    }

    @Override
    public KieSession getKieSession() {
        return this.session;
    }

    @Override
    public <T> DataSource<T> newDataSource(String name, T ... items) {
        CursoredDataSource<T> dataSource = new CursoredDataSource<T>((InternalWorkingMemory)this.session);
        for (T item : items) {
            dataSource.insert(item);
        }
        this.getRuleUnitFactory().bindVariable(name, dataSource);
        return dataSource;
    }

    @Override
    public Collection<?> getSessionObjects() {
        if (this.session != null) {
            return this.session.getObjects();
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<?> getSessionObjects(ObjectFilter filter) {
        if (this.session != null) {
            return this.session.getObjects(filter);
        }
        return Collections.emptyList();
    }

    @Override
    public KieRuntimeLogger addConsoleLogger() {
        if (this.session != null) {
            return KieServices.Factory.get().getLoggers().newConsoleLogger((KieRuntimeEventManager)this.session);
        }
        throw new IllegalStateException("Cannot add logger to the rule unit when the session is not available");
    }

    @Override
    public KieRuntimeLogger addFileLogger(String fileName) {
        if (this.session != null) {
            return KieServices.Factory.get().getLoggers().newFileLogger((KieRuntimeEventManager)this.session, fileName);
        }
        throw new IllegalStateException("Cannot add logger to the rule unit when the session is not available");
    }

    @Override
    public KieRuntimeLogger addFileLogger(String fileName, int maxEventsInMemory) {
        if (this.session != null) {
            return KieServices.Factory.get().getLoggers().newFileLogger((KieRuntimeEventManager)this.session, fileName, maxEventsInMemory);
        }
        throw new IllegalStateException("Cannot add logger to the rule unit when the session is not available");
    }

    @Override
    public KieRuntimeLogger addThreadedFileLogger(String fileName, int interval) {
        if (this.session != null) {
            return KieServices.Factory.get().getLoggers().newThreadedFileLogger((KieRuntimeEventManager)this.session, fileName, interval);
        }
        throw new IllegalStateException("Cannot add logger to the rule unit when the session is not available");
    }

    @Override
    public int run(Class<? extends RuleUnit> ruleUnitClass) {
        return this.internalRun(this.getRuleUnitFactory().getOrCreateRuleUnit(this, ruleUnitClass));
    }

    @Override
    public int run(RuleUnit ruleUnit) {
        return this.internalRun(this.getRuleUnitFactory().injectUnitVariables(this, ruleUnit));
    }

    private int internalRun(RuleUnit ruleUnit) {
        int fired = 0;
        RuleUnit evaluatedUnit = ruleUnit;
        while (evaluatedUnit != null) {
            fired += this.internalExecuteUnit(evaluatedUnit) + this.ruleUnitGuardSystem.fireActiveUnits(evaluatedUnit);
            evaluatedUnit = this.unitsStack.poll();
        }
        return fired;
    }

    public int internalExecuteUnit(RuleUnit ruleUnit) {
        this.currentRuDescr = this.bindRuleUnit(ruleUnit);
        try {
            int n = this.session.fireAllRules();
            return n;
        }
        finally {
            this.unbindCurrentRuleUnit();
        }
    }

    @Override
    public void runUntilHalt(Class<? extends RuleUnit> ruleUnitClass) {
        this.runUntilHalt(this.getRuleUnitFactory().getOrCreateRuleUnit(this, ruleUnitClass));
    }

    @Override
    public void runUntilHalt(RuleUnit ruleUnit) {
        this.currentRuDescr = this.bindRuleUnit(ruleUnit);
        this.session.fireUntilHalt();
    }

    @Override
    public void halt() {
        this.session.halt();
        this.unbindCurrentRuleUnit();
    }

    @Override
    public void switchToRuleUnit(Class<? extends RuleUnit> ruleUnitClass, Activation activation) {
        this.switchToRuleUnit(this.getRuleUnitFactory().getOrCreateRuleUnit(this, ruleUnitClass), activation);
    }

    @Override
    public void switchToRuleUnit(RuleUnit ruleUnit, Activation activation) {
        boolean isActiveUnitCurrent;
        String activateUnitName = activation.getRule().getRuleUnitClassName();
        boolean bl = isActiveUnitCurrent = this.currentRuleUnit != null && this.currentRuleUnit.getClass().getName().equals(activateUnitName);
        if (isActiveUnitCurrent) {
            this.currentRuleUnit.onYield(ruleUnit);
            this.session.getPropagationList().flush();
            InternalAgenda agenda = this.session.getAgenda();
            agenda.removeAgendaGroup(this.currentRuleUnit.getClass().getName());
            this.unitsStack.push(this.currentRuleUnit);
            this.currentRuDescr = this.bindRuleUnit(ruleUnit);
        } else {
            for (int i = 0; i < this.unitsStack.size(); ++i) {
                if (!this.unitsStack.get(i).getClass().getName().equals(activateUnitName)) continue;
                this.unitsStack.add(i, ruleUnit);
                break;
            }
        }
    }

    @Override
    public void guardRuleUnit(Class<? extends RuleUnit> ruleUnitClass, Activation activation) {
        this.ruleUnitGuardSystem.registerGuard(this.getRuleUnitFactory().getOrCreateRuleUnit(this, ruleUnitClass), activation);
    }

    @Override
    public void guardRuleUnit(RuleUnit ruleUnit, Activation activation) {
        this.ruleUnitGuardSystem.registerGuard(this.getRuleUnitFactory().registerUnit(this, ruleUnit), activation);
    }

    @Override
    public void cancelActivation(Activation activation) {
        this.ruleUnitGuardSystem.removeActivation(activation);
    }

    private RuleUnitDescriptionImpl bindRuleUnit(RuleUnit ruleUnit) {
        this.suspended.set(false);
        this.currentRuleUnit = ruleUnit;
        this.currentRuleUnit.onStart();
        this.factHandlesMap.computeIfAbsent(ruleUnit.getClass(), x -> this.session.getEntryPoint("$$units$$").insert((Object)ruleUnit));
        RuleUnitDescriptionImpl ruDescr = (RuleUnitDescriptionImpl)this.session.getKnowledgeBase().getRuleUnitDescriptionRegistry().getDescription((Object)ruleUnit);
        ((Globals)this.session.getGlobalResolver()).setDelegate((Globals)new RuleUnitGlobals(ruDescr, ruleUnit));
        ruDescr.bindDataSources(this.session, ruleUnit);
        InternalAgendaGroup unitGroup = (InternalAgendaGroup)this.session.getAgenda().getAgendaGroup(ruleUnit.getClass().getName());
        unitGroup.setAutoDeactivate(false);
        unitGroup.setFocus();
        return ruDescr;
    }

    private void unbindCurrentRuleUnit() {
        this.currentRuDescr.unbindDataSources(this.session, this.currentRuleUnit);
        ((Globals)this.session.getGlobalResolver()).setDelegate(null);
        this.currentRuleUnit.onEnd();
        this.currentRuleUnit = null;
        this.currentRuDescr = null;
        this.suspended.set(true);
    }

    @Override
    public RuleUnit getCurrentRuleUnit() {
        return this.currentRuleUnit;
    }

    public RuleUnitFactory getRuleUnitFactory() {
        if (this.ruleUnitFactory == null) {
            this.ruleUnitFactory = new RuleUnitFactory();
        }
        return this.ruleUnitFactory;
    }

    @Override
    public RuleUnitExecutor bindVariable(String name, Object value) {
        this.getRuleUnitFactory().bindVariable(name, value);
        if (value instanceof InternalDataSource) {
            this.bindDataSource((InternalDataSource)value);
        }
        return this;
    }

    @Override
    public void bindDataSource(InternalDataSource dataSource) {
        dataSource.setWorkingMemory((InternalWorkingMemory)this.session);
    }

    @Override
    public void onSuspend() {
        if (!this.suspended.getAndSet(true) && this.currentRuleUnit != null) {
            this.currentRuleUnit.onSuspend();
        }
    }

    @Override
    public void onResume() {
        if (this.suspended.getAndSet(false) && this.currentRuleUnit != null) {
            this.currentRuleUnit.onResume();
        }
    }

    @Override
    public void dispose() {
        this.session.dispose();
        this.ruleUnitGuardSystem = null;
        this.ruleUnitFactory = null;
        this.currentRuleUnit = null;
    }

    public static class RuleUnitGlobals
    implements Globals {
        private final RuleUnitDescriptionImpl ruDescr;
        private final RuleUnit ruleUnit;

        private RuleUnitGlobals(RuleUnitDescriptionImpl ruDescr, RuleUnit ruleUnit) {
            this.ruDescr = ruDescr;
            this.ruleUnit = ruleUnit;
        }

        public Object get(String identifier) {
            return this.ruDescr.getValue(this.ruleUnit, identifier);
        }

        public void set(String identifier, Object value) {
            throw new UnsupportedOperationException();
        }

        public void setDelegate(Globals delegate) {
            throw new UnsupportedOperationException();
        }

        public Collection<String> getGlobalKeys() {
            throw new UnsupportedOperationException();
        }
    }
}

