/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.commands;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.NativeQueryStringCommand;
import org.kie.api.command.Command;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.executor.Reoccurring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteSQLQueryCommand
implements org.kie.api.executor.Command,
Reoccurring {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteSQLQueryCommand.class);
    private long nextScheduleTimeAdd = 3600000L;

    public Date getScheduleTime() {
        if (this.nextScheduleTimeAdd < 0L) {
            return null;
        }
        long current = System.currentTimeMillis();
        Date nextSchedule = new Date(current + this.nextScheduleTimeAdd);
        logger.debug("Next schedule for job {} is set to {}", (Object)this.getClass().getSimpleName(), (Object)nextSchedule);
        return nextSchedule;
    }

    public ExecutionResults execute(CommandContext ctx) throws Exception {
        this.computeNextScheduleTime(ctx);
        EntityManagerFactory emf = this.getEntityManager(ctx);
        TransactionalCommandService commandService = new TransactionalCommandService(emf);
        String sql = (String)ctx.getData("SQL");
        String paramsString = (String)ctx.getData("ParametersList");
        HashMap parameters = new HashMap();
        if (paramsString != null && !paramsString.isEmpty()) {
            String[] p = paramsString.split(",");
            Arrays.stream(p).forEach(item -> parameters.put(item, ctx.getData(item)));
        }
        List data = (List)commandService.execute((Command)new NativeQueryStringCommand(sql, parameters));
        ExecutionResults executionResults = new ExecutionResults();
        executionResults.setData("size", (Object)data.size());
        StringBuilder report = new StringBuilder();
        for (Object item2 : data) {
            if (item2 instanceof Object[]) {
                for (Object cell : (Object[])item2) {
                    report.append(cell).append(",");
                }
            } else {
                report.append(item2);
            }
            report.append("\n");
        }
        executionResults.setData("data", (Object)report.toString());
        return executionResults;
    }

    private EntityManagerFactory getEntityManager(CommandContext ctx) {
        String emfName = (String)ctx.getData("EmfName");
        if (emfName == null) {
            emfName = "org.jbpm.domain";
        }
        return EntityManagerFactoryManager.get().getOrCreate(emfName);
    }

    private void computeNextScheduleTime(CommandContext ctx) {
        String nextRun;
        String singleRun = (String)ctx.getData("SingleRun");
        if ("true".equalsIgnoreCase(singleRun)) {
            this.nextScheduleTimeAdd = -1L;
        }
        if ((nextRun = (String)ctx.getData("NextRun")) != null) {
            this.nextScheduleTimeAdd = DateTimeUtils.parseDateAsDuration((String)nextRun);
        }
    }
}

