/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.cdi.impl;

import java.util.List;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.inject.Instance;
import org.jbpm.services.cdi.RequestScopedBackupIdentityProvider;
import org.kie.internal.identity.IdentityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityProviderCDIWrapper
implements IdentityProvider {
    private static final Logger logger = LoggerFactory.getLogger(IdentityProviderCDIWrapper.class);
    private IdentityProvider delegate;
    private Instance<RequestScopedBackupIdentityProvider> backupProviders;

    public IdentityProviderCDIWrapper(IdentityProvider identityProvider, Instance<RequestScopedBackupIdentityProvider> backupProviders) {
        this.delegate = identityProvider;
        this.backupProviders = backupProviders;
    }

    public String getName() {
        String name;
        block5: {
            name = "unknown";
            try {
                name = this.delegate.getName();
                logger.debug("Used original identity provider with user: {}", (Object)name);
            }
            catch (ContextNotActiveException e) {
                if (this.backupProviders.isUnsatisfied()) break block5;
                for (RequestScopedBackupIdentityProvider provider : this.backupProviders) {
                    try {
                        name = provider.getName();
                        if (name == null || "unknown".equals(name)) continue;
                        logger.debug("Used backup identity provider {} with user: {}", (Object)provider, (Object)name);
                        break;
                    }
                    catch (ContextNotActiveException ex) {
                        name = "unknown";
                    }
                }
            }
        }
        return name;
    }

    public List<String> getRoles() {
        List roles = null;
        try {
            roles = this.delegate.getRoles();
            logger.debug("Used original identity provider with roles: {}", (Object)roles);
        }
        catch (ContextNotActiveException e) {
            throw new IllegalStateException("Unable to get roles due to missing context", e);
        }
        return roles;
    }

    public boolean hasRole(String role) {
        try {
            return this.delegate.hasRole(role);
        }
        catch (ContextNotActiveException e) {
            throw new IllegalStateException("Unable to check role membership due to missing context", e);
        }
    }
}

