/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import java.util.Properties;
import org.jbpm.process.instance.impl.util.LoggingPrintStream;
import org.jbpm.test.persistence.util.PersistenceUtil;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.kie.test.util.db.PoolingDataSourceWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBaseTest.class);
    protected static final String DATASOURCE_NAME = "jdbc/jbpm-ds";

    @BeforeClass
    public static void configure() {
        LoggingPrintStream.interceptSysOutSysErr();
    }

    @AfterClass
    public static void reset() {
        LoggingPrintStream.resetInterceptSysOutSysErr();
    }

    protected String getJndiDatasourceName() {
        return DATASOURCE_NAME;
    }

    protected Properties getDataSourceProperties() {
        return PersistenceUtil.getDatasourceProperties();
    }

    protected static PoolingDataSourceWrapper setupPoolingDataSource(String datasourceName) {
        return AbstractBaseTest.setupDataSource(PersistenceUtil.getDatasourceProperties(), datasourceName);
    }

    protected PoolingDataSourceWrapper setupPoolingDataSource() {
        return AbstractBaseTest.setupDataSource(this.getDataSourceProperties(), this.getJndiDatasourceName());
    }

    private static PoolingDataSourceWrapper setupDataSource(Properties dsProps, String datasourceName) {
        PoolingDataSourceWrapper pds;
        try {
            pds = PersistenceUtil.setupPoolingDataSource((Properties)dsProps, (String)datasourceName);
        }
        catch (Exception e) {
            logger.warn("DBPOOL_MGR:Looks like there is an issue with creating db pool because of {} cleaning up...", (Object)e.getMessage());
            logger.info("DBPOOL_MGR: attempting to create db pool again...");
            pds = PersistenceUtil.setupPoolingDataSource((Properties)dsProps, (String)datasourceName);
            logger.info("DBPOOL_MGR:Pool created after cleanup of leftover resources");
        }
        return pds;
    }
}

