/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreUndeployOperations {
    private static Logger logger = LoggerFactory.getLogger(PreUndeployOperations.class);
    private static List<Integer> activeProcessInstancessStates = new ArrayList<Integer>();

    public static Function<DeploymentUnit, Boolean> checkActiveProcessInstances(RuntimeDataService runtimeDataService) {
        return unit -> {
            Collection activeProcesses = runtimeDataService.getProcessInstancesByDeploymentId(unit.getIdentifier(), activeProcessInstancessStates, new QueryContext());
            if (!activeProcesses.isEmpty()) {
                throw new IllegalStateException("Undeploy forbidden - there are active processes instances for deployment " + unit.getIdentifier());
            }
            return true;
        };
    }

    public static Function<DeploymentUnit, Boolean> abortUnitActiveProcessInstances(RuntimeDataService runtimeDataService, DeploymentService deploymentService) {
        return unit -> {
            Collection activeProcesses = runtimeDataService.getProcessInstancesByDeploymentId(unit.getIdentifier(), activeProcessInstancessStates, new QueryContext(Integer.valueOf(0), Integer.valueOf(-1)));
            DeployedUnit deployedUnit = deploymentService.getDeployedUnit(unit.getIdentifier());
            if (deployedUnit == null) {
                throw new IllegalStateException("Undeploy forbidden - No deployments available for " + unit.getIdentifier());
            }
            for (ProcessInstanceDesc instanceDesc : activeProcesses) {
                RuntimeManager manager = deployedUnit.getRuntimeManager();
                RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)instanceDesc.getId()));
                try {
                    KieSession ksession = engine.getKieSession();
                    ksession.abortProcessInstance(instanceDesc.getId().longValue());
                }
                catch (Exception e) {
                    logger.error("Undeploy forbidden - Error aborting process instances for deployment unit {} due to: {}", (Object)unit.getIdentifier(), (Object)e.getMessage());
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    manager.disposeRuntimeEngine(engine);
                }
            }
            return true;
        };
    }

    public static Function<DeploymentUnit, Boolean> doNothing() {
        return unit -> true;
    }

    static {
        activeProcessInstancessStates.add(1);
        activeProcessInstancessStates.add(0);
        activeProcessInstancessStates.add(4);
    }
}

