/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.maven.integration;

import java.io.InputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.integration.embedder.MavenProjectLoader;
import org.appformer.maven.support.AFReleaseId;
import org.appformer.maven.support.AFReleaseIdImpl;
import org.appformer.maven.support.PomModel;
import org.appformer.maven.support.PomModelGenerator;

public class MavenPomModelGenerator
implements PomModelGenerator {
    public PomModel parse(String path, InputStream pomStream) {
        return new MavenModel(MavenProjectLoader.parseMavenPom(pomStream));
    }

    public static class MavenModel
    extends PomModel.InternalModel {
        private final MavenProject mavenProject;

        public MavenModel(MavenProject mavenProject) {
            this.mavenProject = mavenProject;
            this.setReleaseId(this.initReleaseId(mavenProject));
            this.setParentReleaseId(this.initParentReleaseId(mavenProject));
            this.initDependencies(mavenProject);
        }

        public MavenProject getMavenProject() {
            return this.mavenProject;
        }

        private AFReleaseId initReleaseId(MavenProject mavenProject) {
            return new AFReleaseIdImpl(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion());
        }

        private AFReleaseId initParentReleaseId(MavenProject mavenProject) {
            try {
                MavenProject parentProject = mavenProject.getParent();
                if (parentProject != null) {
                    return new AFReleaseIdImpl(parentProject.getGroupId(), parentProject.getArtifactId(), parentProject.getVersion());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private void initDependencies(MavenProject mavenProject) {
            for (Artifact dep : mavenProject.getArtifacts()) {
                this.addDependency((AFReleaseId)new AFReleaseIdImpl(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getType()), dep.getScope());
            }
        }
    }
}

