/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.audit;

import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import org.jbpm.casemgmt.impl.audit.CaseInstanceAuditEventListener;
import org.jbpm.casemgmt.impl.jms.AsyncCaseInstanceAuditEventProducer;
import org.jbpm.shared.services.impl.TransactionalCommandService;

public class CaseInstanceAuditLoggerFactory {
    public static CaseInstanceAuditEventListener newJPAInstance(TransactionalCommandService transactionalCommandService) {
        return new CaseInstanceAuditEventListener(transactionalCommandService);
    }

    public static CaseInstanceAuditEventListener newJPAInstance(EntityManagerFactory emf) {
        return new CaseInstanceAuditEventListener(new TransactionalCommandService(emf));
    }

    public static AsyncCaseInstanceAuditEventProducer newJMSInstance(Map<String, Object> properties) {
        Queue queue;
        ConnectionFactory connFactory;
        AsyncCaseInstanceAuditEventProducer logger = new AsyncCaseInstanceAuditEventProducer();
        boolean transacted = true;
        if (properties.containsKey("jbpm.audit.jms.transacted")) {
            Object transactedObj = properties.get("jbpm.audit.jms.transacted");
            transacted = transactedObj instanceof Boolean ? (Boolean)properties.get("jbpm.audit.jms.transacted") : Boolean.parseBoolean(transactedObj.toString());
        }
        logger.setTransacted(transacted);
        if (properties.containsKey("jbpm.audit.jms.connection.factory")) {
            connFactory = (ConnectionFactory)properties.get("jbpm.audit.jms.connection.factory");
            logger.setConnectionFactory(connFactory);
        }
        if (properties.containsKey("jbpm.audit.jms.queue")) {
            queue = (Queue)properties.get("jbpm.audit.jms.queue");
            logger.setQueue(queue);
        }
        try {
            if (properties.containsKey("jbpm.audit.jms.connection.factory.jndi")) {
                connFactory = (ConnectionFactory)InitialContext.doLookup((String)properties.get("jbpm.audit.jms.connection.factory.jndi"));
                logger.setConnectionFactory(connFactory);
            }
            if (properties.containsKey("jbpm.audit.jms.queue.jndi")) {
                queue = (Queue)InitialContext.doLookup((String)properties.get("jbpm.audit.jms.queue.jndi"));
                logger.setQueue(queue);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException("Error when looking up ConnectionFactory/Queue", e);
        }
        return logger;
    }

    public static AsyncCaseInstanceAuditEventProducer newJMSInstance(boolean transacted, ConnectionFactory connFactory, Queue queue) {
        AsyncCaseInstanceAuditEventProducer logger = new AsyncCaseInstanceAuditEventProducer();
        logger.setTransacted(transacted);
        logger.setConnectionFactory(connFactory);
        logger.setQueue(queue);
        return logger;
    }
}

