/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jbpm.casemgmt.api.CaseNotFoundException;
import org.jbpm.casemgmt.api.CaseRuntimeDataService;
import org.jbpm.casemgmt.api.CaseService;
import org.jbpm.casemgmt.api.generator.CaseIdGenerator;
import org.jbpm.casemgmt.api.model.AdHocFragment;
import org.jbpm.casemgmt.api.model.CaseDefinition;
import org.jbpm.casemgmt.api.model.CaseFileItem;
import org.jbpm.casemgmt.api.model.CaseMilestone;
import org.jbpm.casemgmt.api.model.CaseRole;
import org.jbpm.casemgmt.api.model.CaseStage;
import org.jbpm.casemgmt.api.model.CaseStatus;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.api.model.instance.CaseMilestoneInstance;
import org.jbpm.casemgmt.api.model.instance.CaseStageInstance;
import org.jbpm.casemgmt.api.model.instance.StageStatus;
import org.jbpm.casemgmt.impl.model.AdHocFragmentImpl;
import org.jbpm.casemgmt.impl.model.CaseDefinitionComparator;
import org.jbpm.casemgmt.impl.model.CaseDefinitionImpl;
import org.jbpm.casemgmt.impl.model.CaseMilestoneImpl;
import org.jbpm.casemgmt.impl.model.CaseRoleImpl;
import org.jbpm.casemgmt.impl.model.CaseStageImpl;
import org.jbpm.casemgmt.impl.model.ProcessDefinitionComparator;
import org.jbpm.casemgmt.impl.model.instance.CaseMilestoneInstanceImpl;
import org.jbpm.casemgmt.impl.model.instance.CaseStageInstanceImpl;
import org.jbpm.kie.services.impl.CommonUtils;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.kie.services.impl.security.DeploymentRolesManager;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.identity.UserDataServiceProvider;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.DeployedAsset;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.service.ServiceRegistry;
import org.jbpm.shared.services.impl.QueryManager;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.StartNode;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.KieInternalServices;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;

public class CaseRuntimeDataServiceImpl
implements CaseRuntimeDataService,
DeploymentEventListener {
    protected Set<CaseDefinitionImpl> availableCases = new HashSet<CaseDefinitionImpl>();
    protected Set<ProcessDefinition> availableProcesses = new HashSet<ProcessDefinition>();
    private CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
    private CaseIdGenerator caseIdGenerator;
    private RuntimeDataService runtimeDataService;
    private TransactionalCommandService commandService;
    private CaseService caseService;
    private IdentityProvider identityProvider;
    private UserGroupCallback userGroupCallback = UserDataServiceProvider.getUserGroupCallback();
    private DeploymentRolesManager deploymentRolesManager = new DeploymentRolesManager();
    private List<CaseStatus> statuses = Arrays.asList(CaseStatus.OPEN);
    private static final List<Status> allActiveStatus = Arrays.asList(Status.Created, Status.Ready, Status.Reserved, Status.InProgress, Status.Suspended);

    public CaseRuntimeDataServiceImpl() {
        QueryManager.get().addNamedQueries("META-INF/CaseMgmtorm.xml");
        ServiceRegistry.get().register(CaseRuntimeDataService.class.getSimpleName(), (Object)this);
    }

    public CaseIdGenerator getCaseIdGenerator() {
        return this.caseIdGenerator;
    }

    public void setCaseIdGenerator(CaseIdGenerator caseIdGenerator) {
        this.caseIdGenerator = caseIdGenerator;
    }

    public void setRuntimeDataService(RuntimeDataService runtimeDataService) {
        this.runtimeDataService = runtimeDataService;
    }

    public void setCaseService(CaseService caseService) {
        this.caseService = caseService;
    }

    public void setCommandService(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public void setUserGroupCallback(UserGroupCallback userGroupCallback) {
        this.userGroupCallback = userGroupCallback;
    }

    public void setDeploymentRolesManager(DeploymentRolesManager deploymentRolesManager) {
        this.deploymentRolesManager = deploymentRolesManager;
    }

    public void onDeploy(DeploymentEvent event) {
        AbstractRuntimeManager runtimeManager = (AbstractRuntimeManager)event.getDeployedUnit().getRuntimeManager();
        KieBase kieBase = runtimeManager.getEnvironment().getKieBase();
        Collection processes = kieBase.getProcesses();
        Map<String, DeployedAsset> mapProcessById = event.getDeployedUnit().getDeployedAssets().stream().collect(Collectors.toMap(DeployedAsset::getId, asset -> asset));
        for (Process process : processes) {
            if (!((WorkflowProcess)process).isDynamic()) continue;
            String caseIdPrefix = this.collectCaseIdPrefix(process);
            Collection<CaseMilestone> caseMilestones = this.collectMilestoness(process);
            Collection<CaseStage> caseStages = this.collectCaseStages(event.getDeploymentId(), process.getId(), (NodeContainer)((WorkflowProcess)process));
            Collection<CaseRole> caseRoles = this.collectCaseRoles(process);
            Collection<AdHocFragment> adHocFragments = this.collectAdHocFragments((NodeContainer)((WorkflowProcess)process));
            Map<String, List<String>> dataAccessRestrictions = this.collectDataAccessRestrictions(process);
            CaseDefinitionImpl caseDef = new CaseDefinitionImpl((ProcessAssetDesc)mapProcessById.get(process.getId()), caseIdPrefix, caseStages, caseMilestones, caseRoles, adHocFragments, dataAccessRestrictions);
            caseDef.setIdentifierPrefixSequence(this.collectCaseIdPrefixIsSequence(process));
            this.availableCases.add(caseDef);
        }
        Collection assets = event.getDeployedUnit().getDeployedAssets();
        List roles = null;
        for (DeployedAsset asset2 : assets) {
            if (!(asset2 instanceof ProcessAssetDesc)) continue;
            if (!((ProcessAssetDesc)asset2).isDynamic()) {
                this.availableProcesses.add((ProcessDefinition)((ProcessAssetDesc)asset2));
            }
            if (roles != null) continue;
            roles = ((ProcessAssetDesc)asset2).getRoles();
        }
        if (roles == null) {
            roles = Collections.emptyList();
        }
        this.deploymentRolesManager.addRolesForDeployment(event.getDeploymentId(), roles);
    }

    public void onUnDeploy(DeploymentEvent event) {
        Collection undeployed = this.availableCases.stream().filter(caseDef -> caseDef.getDeploymentId().equals(event.getDeploymentId())).collect(Collectors.toList());
        this.availableCases.removeAll(undeployed);
        Collection undeployedProcesses = this.availableProcesses.stream().filter(process -> process.getDeploymentId().equals(event.getDeploymentId())).collect(Collectors.toList());
        this.availableProcesses.removeAll(undeployedProcesses);
        this.availableCases.forEach(e -> e.getResolvedIdentifierPrefixes().forEach(casePrefix -> this.caseIdGenerator.unregister(casePrefix)));
        this.deploymentRolesManager.removeRolesForDeployment(event.getDeploymentId());
    }

    public void onActivate(DeploymentEvent event) {
    }

    public void onDeactivate(DeploymentEvent event) {
    }

    public CaseDefinition getCase(String deploymentId, String caseDefinitionId) {
        return this.availableCases.stream().filter(caseDef -> caseDef.getDeploymentId().equals(deploymentId) && caseDef.getId().equals(caseDefinitionId)).findFirst().orElse(null);
    }

    public Collection<CaseDefinition> getCases(QueryContext queryContext) {
        Collection cases = this.availableCases.stream().filter(caseDef -> caseDef.isActive()).sorted(new CaseDefinitionComparator(queryContext.getOrderBy(), queryContext.isAscending())).skip(queryContext.getOffset().intValue()).limit(queryContext.getCount().intValue()).collect(Collectors.toList());
        return cases;
    }

    public Collection<CaseDefinition> getCases(String filter, QueryContext queryContext) {
        String pattern = "(?i)^.*" + filter + ".*$";
        Collection cases = this.availableCases.stream().filter(caseDef -> caseDef.isActive() && (caseDef.getId().matches(pattern) || caseDef.getName().matches(pattern))).sorted(new CaseDefinitionComparator(queryContext.getOrderBy(), queryContext.isAscending())).skip(queryContext.getOffset().intValue()).limit(queryContext.getCount().intValue()).collect(Collectors.toList());
        return cases;
    }

    public Collection<CaseDefinition> getCasesByDeployment(String deploymentId, QueryContext queryContext) {
        Collection cases = this.availableCases.stream().filter(caseDef -> caseDef.isActive() && caseDef.getDeploymentId().equals(deploymentId)).sorted(new CaseDefinitionComparator(queryContext.getOrderBy(), queryContext.isAscending())).skip(queryContext.getOffset().intValue()).limit(queryContext.getCount().intValue()).collect(Collectors.toList());
        return cases;
    }

    public Collection<ProcessDefinition> getProcessDefinitions(QueryContext queryContext) {
        Collection cases = this.availableProcesses.stream().filter(caseDef -> caseDef.isActive()).sorted(new ProcessDefinitionComparator(queryContext.getOrderBy(), queryContext.isAscending())).skip(queryContext.getOffset().intValue()).limit(queryContext.getCount().intValue()).collect(Collectors.toList());
        return cases;
    }

    public Collection<ProcessDefinition> getProcessDefinitions(String filter, QueryContext queryContext) {
        String pattern = "(?i)^.*" + filter + ".*$";
        Collection cases = this.availableProcesses.stream().filter(caseDef -> caseDef.isActive() && (caseDef.getId().matches(pattern) || caseDef.getName().matches(pattern))).sorted(new ProcessDefinitionComparator(queryContext.getOrderBy(), queryContext.isAscending())).skip(queryContext.getOffset().intValue()).limit(queryContext.getCount().intValue()).collect(Collectors.toList());
        return cases;
    }

    public Collection<ProcessDefinition> getProcessDefinitionsByDeployment(String deploymentId, QueryContext queryContext) {
        Collection cases = this.availableProcesses.stream().filter(caseDef -> caseDef.isActive() && caseDef.getDeploymentId().equals(deploymentId)).sorted(new ProcessDefinitionComparator(queryContext.getOrderBy(), queryContext.isAscending())).skip(queryContext.getOffset().intValue()).limit(queryContext.getCount().intValue()).collect(Collectors.toList());
        return cases;
    }

    public Collection<ProcessInstanceDesc> getProcessInstancesForCase(String caseId, QueryContext queryContext) {
        CorrelationKey correlationKey = this.correlationKeyFactory.newCorrelationKey(caseId);
        return this.runtimeDataService.getProcessInstancesByCorrelationKey(correlationKey, queryContext);
    }

    public Collection<ProcessInstanceDesc> getProcessInstancesForCase(String caseId, List<Integer> processStates, QueryContext queryContext) {
        CorrelationKey correlationKey = this.correlationKeyFactory.newCorrelationKey(caseId);
        return this.runtimeDataService.getProcessInstancesByCorrelationKeyAndStatus(correlationKey, processStates, queryContext);
    }

    public Collection<CaseMilestoneInstance> getCaseInstanceMilestones(String caseId, boolean achievedOnly, QueryContext queryContext) {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceByCorrelationKey(this.correlationKeyFactory.newCorrelationKey(caseId));
        if (pi == null || !pi.getState().equals(1)) {
            throw new CaseNotFoundException("No case instance found with id " + caseId + " or it's not active anymore");
        }
        CorrelationKey correlationKey = this.correlationKeyFactory.newCorrelationKey(caseId);
        Collection nodes = this.runtimeDataService.getNodeInstancesByCorrelationKeyNodeType(correlationKey, Arrays.asList(1, 3), Arrays.asList("MilestoneNode"), queryContext);
        Map<String, List<CaseMilestoneInstance>> milestonesGroup = nodes.stream().map(n -> (org.jbpm.kie.services.impl.model.NodeInstanceDesc)n).filter(n -> n.getType() == 1).map(n -> new CaseMilestoneInstanceImpl(String.valueOf(n.getId()), n.getName(), true, n.getDataTimeStamp())).collect(Collectors.groupingBy(CaseMilestoneInstance::getName));
        List milestones = milestonesGroup.values().stream().map(e -> (CaseMilestoneInstance)e.stream().min(this::compareMilestones).get()).collect(Collectors.toList());
        List foundMilestones = milestones.stream().map(CaseMilestoneInstance::getName).collect(Collectors.toList());
        if (!achievedOnly) {
            CaseDefinition caseDef = this.getCase(pi.getDeploymentId(), pi.getProcessId());
            caseDef.getCaseMilestones().stream().filter(cm -> !foundMilestones.contains(cm.getName())).map(cm -> new CaseMilestoneInstanceImpl(cm.getId(), cm.getName(), false, null)).forEach(cmi -> milestones.add(cmi));
        }
        List sortedMilestones = milestones.stream().sorted(this::compareMilestones).collect(Collectors.toList());
        return this.applyPagination(sortedMilestones, queryContext);
    }

    private int compareMilestones(CaseMilestoneInstance o1, CaseMilestoneInstance o2) {
        if (o1.getAchievedAt() == null) {
            return -1;
        }
        if (o2.getAchievedAt() == null) {
            return 1;
        }
        return o1.getAchievedAt().compareTo(o2.getAchievedAt());
    }

    public Collection<CaseStageInstance> getCaseInstanceStages(String caseId, boolean activeOnly, QueryContext queryContext) {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceByCorrelationKey(this.correlationKeyFactory.newCorrelationKey(caseId));
        if (pi == null || !pi.getState().equals(1)) {
            throw new CaseNotFoundException("No case instance found with id " + caseId + " or it's not active anymore");
        }
        CaseDefinition caseDef = this.getCase(pi.getDeploymentId(), pi.getProcessId());
        List<CaseStageInstance> stages = this.internalGetCaseStages(caseDef, caseId, activeOnly, queryContext);
        return this.applyPagination(stages, queryContext);
    }

    public Collection<NodeInstanceDesc> getActiveNodesForCase(String caseId, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("caseId", caseId + "%");
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List nodeInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getActiveNodesForCase", params));
        return nodeInstances;
    }

    public Collection<NodeInstanceDesc> getCompletedNodesForCase(String caseId, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("caseId", caseId + "%");
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List nodeInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getCompletedNodesForCase", params));
        return nodeInstances;
    }

    public Collection<CaseInstance> getCaseInstances(QueryContext queryContext) {
        return this.getCaseInstances(this.statuses, queryContext);
    }

    public Collection<CaseInstance> getCaseInstances(boolean withData, QueryContext queryContext) {
        return this.getCaseInstances(this.statuses, withData, queryContext);
    }

    public Collection<CaseInstance> getCaseInstances(List<CaseStatus> statuses, QueryContext queryContext) {
        return this.getCaseInstances(statuses, false, queryContext);
    }

    public Collection<CaseInstance> getCaseInstances(List<CaseStatus> statuses, boolean withData, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("statuses", this.resolveCaseStatuses(statuses));
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        return this.fillCaseFiles((Collection)this.commandService.execute((Command)new QueryNameCommand("getCaseInstances", params)), withData);
    }

    public Collection<CaseInstance> getSubCaseInstancesByParentCaseId(String parentCaseId, List<CaseStatus> statuses, QueryContext queryContext) {
        return this.getSubCases(Arrays.asList(parentCaseId), statuses, queryContext);
    }

    public Collection<CaseInstance> getAllDescendantSubCaseInstancesByParentCaseId(String parentCaseId, List<CaseStatus> statuses) {
        Collection<CaseInstance> processInstances;
        ArrayList<CaseInstance> cases = new ArrayList<CaseInstance>();
        List<String> ids = Arrays.asList(parentCaseId);
        do {
            processInstances = this.getSubCases(ids, statuses, null);
            cases.addAll(processInstances);
        } while (!(ids = processInstances.stream().map(CaseInstance::getCaseId).collect(Collectors.toList())).isEmpty());
        return cases;
    }

    private Collection<CaseInstance> getSubCases(List<String> parentCaseId, List<CaseStatus> statuses, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parentCaseId", parentCaseId);
        params.put("statuses", this.resolveCaseStatuses(statuses));
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        return (Collection)this.commandService.execute((Command)new QueryNameCommand("getSubCaseInstancesByParentCaseIds", params));
    }

    public Collection<CaseInstance> getCaseInstancesByDeployment(String deploymentId, List<CaseStatus> statuses, QueryContext queryContext) {
        return this.getCaseInstancesByDeployment(deploymentId, statuses, false, queryContext);
    }

    public Collection<CaseInstance> getCaseInstancesByDeployment(String deploymentId, List<CaseStatus> statuses, boolean withData, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("deploymentId", deploymentId);
        params.put("statuses", this.resolveCaseStatuses(statuses));
        params.put("entities", this.collectUserAuthInfo());
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        return this.fillCaseFiles((Collection)this.commandService.execute((Command)new QueryNameCommand("getCaseInstancesByDeployment", params)), withData);
    }

    public Collection<CaseInstance> getCaseInstancesByDefinition(String definitionId, List<CaseStatus> statuses, QueryContext queryContext) {
        return this.getCaseInstancesByDefinition(definitionId, statuses, false, queryContext);
    }

    public Collection<CaseInstance> getCaseInstancesByDefinition(String definitionId, List<CaseStatus> statuses, boolean withData, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("definitionId", definitionId);
        params.put("statuses", this.resolveCaseStatuses(statuses));
        params.put("entities", this.collectUserAuthInfo());
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        return this.fillCaseFiles((Collection)this.commandService.execute((Command)new QueryNameCommand("getCaseInstancesByDefinition", params)), withData);
    }

    public Collection<CaseInstance> getCaseInstancesOwnedBy(String owner, List<CaseStatus> statuses, QueryContext queryContext) {
        return this.getCaseInstancesOwnedBy(owner, statuses, false, queryContext);
    }

    public Collection<CaseInstance> getCaseInstancesOwnedBy(String owner, List<CaseStatus> statuses, boolean withData, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("owner", owner);
        params.put("statuses", this.resolveCaseStatuses(statuses));
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        return this.fillCaseFiles((Collection)this.commandService.execute((Command)new QueryNameCommand("getCaseInstancesOwnedBy", params)), withData);
    }

    public Collection<CaseInstance> getCaseInstancesByRole(String roleName, List<CaseStatus> statuses, QueryContext queryContext) {
        return this.getCaseInstancesByRole(roleName, statuses, false, queryContext);
    }

    public Collection<CaseInstance> getCaseInstancesByRole(String roleName, List<CaseStatus> statuses, boolean withData, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("roleName", roleName);
        params.put("entities", this.collectUserAuthInfo());
        params.put("statuses", this.resolveCaseStatuses(statuses));
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        return this.fillCaseFiles((Collection)this.commandService.execute((Command)new QueryNameCommand("getCaseInstancesByRole", params)), withData);
    }

    public Collection<CaseInstance> getCaseInstancesAnyRole(List<CaseStatus> statuses, QueryContext queryContext) {
        return this.getCaseInstancesAnyRole(statuses, false, queryContext);
    }

    public Collection<CaseInstance> getCaseInstancesAnyRole(List<CaseStatus> statuses, boolean withData, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("entities", this.collectUserAuthInfo());
        params.put("statuses", this.resolveCaseStatuses(statuses));
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        return this.fillCaseFiles((Collection)this.commandService.execute((Command)new QueryNameCommand("getCaseInstancesAnyRole", params)), withData);
    }

    public Collection<CaseInstance> getCaseInstancesByDataItem(String dataItemName, List<CaseStatus> statuses, QueryContext queryContext) {
        return this.getCaseInstancesByDataItem(dataItemName, statuses, false, queryContext);
    }

    public Collection<CaseInstance> getCaseInstancesByDataItem(String dataItemName, List<CaseStatus> statuses, boolean withData, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemName", dataItemName);
        params.put("entities", this.collectUserAuthInfo());
        params.put("statuses", this.resolveCaseStatuses(statuses));
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        return this.fillCaseFiles((Collection)this.commandService.execute((Command)new QueryNameCommand("getCaseInstancesByVariableName", params)), withData);
    }

    public Collection<CaseInstance> getCaseInstancesByDataItemAndValue(String dataItemName, String dataItemValue, List<CaseStatus> statuses, QueryContext queryContext) {
        return this.getCaseInstancesByDataItemAndValue(dataItemName, dataItemValue, statuses, false, queryContext);
    }

    public Collection<CaseInstance> getCaseInstancesByDataItemAndValue(String dataItemName, String dataItemValue, List<CaseStatus> statuses, boolean withData, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemName", dataItemName);
        params.put("itemValue", dataItemValue);
        params.put("entities", this.collectUserAuthInfo());
        params.put("statuses", this.resolveCaseStatuses(statuses));
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        return this.fillCaseFiles((Collection)this.commandService.execute((Command)new QueryNameCommand("getCaseInstancesByVariableNameAndValue", params)), withData);
    }

    public CaseInstance getCaseInstanceById(String caseId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("correlationKey", caseId);
        params.put("maxResults", 1);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getCaseInstanceById", params));
        if (!processInstances.isEmpty()) {
            return (CaseInstance)processInstances.get(0);
        }
        throw new CaseNotFoundException("Case " + caseId + " was not found");
    }

    public Collection<AdHocFragment> getAdHocFragmentsForCase(String caseId) {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceByCorrelationKey(this.correlationKeyFactory.newCorrelationKey(caseId));
        if (pi == null || !pi.getState().equals(1)) {
            throw new CaseNotFoundException("No case instance found with id " + caseId + " or it's not active anymore");
        }
        CaseDefinition caseDef = this.getCase(pi.getDeploymentId(), pi.getProcessId());
        ArrayList<AdHocFragment> adHocFragments = new ArrayList<AdHocFragment>();
        adHocFragments.addAll(caseDef.getAdHocFragments());
        List<CaseStageInstance> activeStages = this.internalGetCaseStages(caseDef, caseId, true, new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
        activeStages.forEach(stage -> adHocFragments.addAll(stage.getAdHocFragments()));
        return adHocFragments;
    }

    public List<TaskSummary> getCaseTasksAssignedAsPotentialOwner(String caseId, String userId, List<Status> status, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("caseId", caseId + "%");
        params.put("userId", userId);
        params.put("status", this.adoptList(status, allActiveStatus));
        params.put("groupIds", CommonUtils.getCallbackUserRoles((UserGroupCallback)this.userGroupCallback, (String)userId));
        this.applyQueryContext(params, queryContext);
        List tasks = (List)this.commandService.execute((Command)new QueryNameCommand("getCaseTasksAsPotentialOwner", params));
        return tasks;
    }

    public List<TaskSummary> getCaseTasksAssignedAsBusinessAdmin(String caseId, String userId, List<Status> status, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("caseId", caseId + "%");
        params.put("userId", userId);
        params.put("status", this.adoptList(status, allActiveStatus));
        params.put("groupIds", CommonUtils.getCallbackUserRoles((UserGroupCallback)this.userGroupCallback, (String)userId));
        this.applyQueryContext(params, queryContext);
        List tasks = (List)this.commandService.execute((Command)new QueryNameCommand("getCaseTasksAsBusinessAdmin", params));
        return tasks;
    }

    public List<TaskSummary> getCaseTasksAssignedAsStakeholder(String caseId, String userId, List<Status> status, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("caseId", caseId + "%");
        params.put("userId", userId);
        params.put("status", this.adoptList(status, allActiveStatus));
        params.put("groupIds", CommonUtils.getCallbackUserRoles((UserGroupCallback)this.userGroupCallback, (String)userId));
        this.applyQueryContext(params, queryContext);
        List tasks = (List)this.commandService.execute((Command)new QueryNameCommand("getCaseTasksAsStakeholder", params));
        return tasks;
    }

    public List<CaseStageInstance> internalGetCaseStages(CaseDefinition caseDef, String caseId, boolean activeOnly, QueryContext queryContext) {
        CorrelationKey correlationKey = this.correlationKeyFactory.newCorrelationKey(caseId);
        Collection nodes = this.runtimeDataService.getNodeInstancesByCorrelationKeyNodeType(correlationKey, Arrays.asList(1), Arrays.asList("DynamicNode"), queryContext);
        List<Long> completedNodes = this.filterStagesByStatus(nodes, 1);
        List<Long> cancelledNodes = this.filterStagesByStatus(nodes, 2);
        Map<String, CaseStage> stagesByName = caseDef.getCaseStages().stream().collect(Collectors.toMap(CaseStage::getId, c -> c));
        Predicate<NodeInstanceDesc> filterNodes = null;
        filterNodes = activeOnly ? n -> ((org.jbpm.kie.services.impl.model.NodeInstanceDesc)n).getType() == 0 && !completedNodes.contains(((org.jbpm.kie.services.impl.model.NodeInstanceDesc)n).getId()) && !cancelledNodes.contains(((org.jbpm.kie.services.impl.model.NodeInstanceDesc)n).getId()) : n -> ((org.jbpm.kie.services.impl.model.NodeInstanceDesc)n).getType() == 0;
        ArrayList triggeredStages = new ArrayList();
        ArrayList<CaseStageInstance> stages = new ArrayList<CaseStageInstance>();
        nodes.stream().filter(filterNodes).map(n -> {
            StageStatus status = StageStatus.Active;
            if (completedNodes.contains(((org.jbpm.kie.services.impl.model.NodeInstanceDesc)n).getId())) {
                status = StageStatus.Completed;
            }
            Collection<NodeInstanceDesc> activeNodes = this.getActiveNodesForCaseAndStage(caseId, n.getNodeId(), new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
            if (cancelledNodes.contains(((org.jbpm.kie.services.impl.model.NodeInstanceDesc)n).getId())) {
                status = StageStatus.Canceled;
            }
            return new CaseStageInstanceImpl(n.getNodeId(), n.getName(), ((CaseStage)stagesByName.get(n.getNodeId())).getAdHocFragments(), activeNodes, status);
        }).forEach(csi -> {
            stages.add((CaseStageInstance)csi);
            triggeredStages.add(csi.getName());
        });
        if (!activeOnly) {
            caseDef.getCaseStages().stream().filter(cs -> !triggeredStages.contains(cs.getName())).map(cs -> new CaseStageInstanceImpl(cs.getId(), cs.getName(), cs.getAdHocFragments(), Collections.emptyList(), StageStatus.Available)).forEach(csi -> stages.add((CaseStageInstance)csi));
        }
        return stages;
    }

    protected Collection<NodeInstanceDesc> getActiveNodesForCaseAndStage(String caseId, String stageId, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("caseId", caseId + "%");
        params.put("nodeContainerId", stageId);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List nodeInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getActiveNodesForCaseAndStage", params));
        return nodeInstances;
    }

    private Collection<CaseRole> collectCaseRoles(Process process) {
        String[] roleStrings;
        String roles = (String)process.getMetaData().get("customCaseRoles");
        if (roles == null) {
            return Collections.emptyList();
        }
        ArrayList<CaseRole> result = new ArrayList<CaseRole>();
        for (String roleString : roleStrings = roles.split(",")) {
            String[] elements = roleString.split(":");
            CaseRoleImpl role = new CaseRoleImpl(elements[0]);
            result.add(role);
            if (elements.length <= 1) continue;
            role.setCardinality(Integer.parseInt(elements[1]));
        }
        return result;
    }

    private List<Long> filterStagesByStatus(Collection<NodeInstanceDesc> nodes, int status) {
        return nodes.stream().filter(n -> ((org.jbpm.kie.services.impl.model.NodeInstanceDesc)n).getType() == status).map(NodeInstanceDesc::getId).collect(Collectors.toList());
    }

    private String collectCaseIdPrefix(Process process) {
        String caseIdPrefix = (String)process.getMetaData().get("customCaseIdPrefix");
        if (caseIdPrefix == null) {
            return CaseDefinition.DEFAULT_PREFIX;
        }
        return caseIdPrefix;
    }

    private boolean collectCaseIdPrefixIsSequence(Process process) {
        if (!process.getMetaData().containsKey("customCaseIdPrefixIsSequence")) {
            return true;
        }
        return Boolean.parseBoolean((String)process.getMetaData().get("customCaseIdPrefixIsSequence"));
    }

    private Collection<CaseMilestone> collectMilestoness(Process process) {
        ArrayList<CaseMilestone> result = new ArrayList<CaseMilestone>();
        this.getMilestones((NodeContainer)((WorkflowProcess)process), result);
        return result;
    }

    private void getMilestones(NodeContainer container, Collection<CaseMilestone> result) {
        for (Node node : container.getNodes()) {
            if (node instanceof MilestoneNode) {
                result.add(new CaseMilestoneImpl((String)node.getMetaData().get("UniqueId"), node.getName(), ((MilestoneNode)node).getConstraint(), false));
            }
            if (!(node instanceof NodeContainer)) continue;
            this.getMilestones((NodeContainer)node, result);
        }
    }

    private Collection<CaseStage> collectCaseStages(String deploymentId, String processId, NodeContainer process) {
        ArrayList<CaseStage> result = new ArrayList<CaseStage>();
        for (Node node : process.getNodes()) {
            if (!(node instanceof DynamicNode)) continue;
            DynamicNode dynamicNode = (DynamicNode)node;
            Collection<AdHocFragment> adHocFragments = this.collectAdHocFragments((NodeContainer)dynamicNode);
            result.add(new CaseStageImpl((String)((DynamicNode)node).getMetaData("UniqueId"), node.getName(), adHocFragments));
        }
        return result;
    }

    private Collection<AdHocFragment> collectAdHocFragments(NodeContainer process) {
        ArrayList<AdHocFragment> result = new ArrayList<AdHocFragment>();
        this.checkAdHoc(process, result);
        return result;
    }

    private Map<String, List<String>> collectDataAccessRestrictions(Process process) {
        String[] accessStrings;
        String dataAccess = (String)process.getMetaData().get("customCaseDataAccess");
        if (dataAccess == null) {
            return new HashMap<String, List<String>>();
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (String accessString : accessStrings = dataAccess.split(";")) {
            String[] elements = accessString.split(":");
            String dataItem = elements[0];
            List<String> roles = Arrays.asList(elements[1].split(","));
            result.put(dataItem, roles);
        }
        return result;
    }

    private void checkAdHoc(NodeContainer nodeContainer, List<AdHocFragment> result) {
        for (Node node : nodeContainer.getNodes()) {
            if (node instanceof StartNode || node instanceof BoundaryEventNode || !node.getIncomingConnections().isEmpty()) continue;
            result.add(new AdHocFragmentImpl(node.getName(), node.getClass().getSimpleName()));
        }
    }

    protected void applyQueryContext(Map<String, Object> params, QueryContext queryContext) {
        if (queryContext != null) {
            params.put("firstResult", queryContext.getOffset());
            params.put("maxResults", queryContext.getCount());
            if (queryContext.getOrderBy() != null && !queryContext.getOrderBy().isEmpty()) {
                params.put("orderby", queryContext.getOrderBy());
                if (queryContext.isAscending().booleanValue()) {
                    params.put("asc", "true");
                } else {
                    params.put("desc", "true");
                }
            }
        }
    }

    protected void applyDeploymentFilter(Map<String, Object> params) {
        List deploymentIdForUser;
        if (this.deploymentRolesManager != null && (deploymentIdForUser = this.deploymentRolesManager.getDeploymentsForUser(this.identityProvider)) != null && !deploymentIdForUser.isEmpty()) {
            params.put("filter", " log.externalId in (:deployments) ");
            params.put("deployments", deploymentIdForUser);
        }
    }

    protected List<?> adoptList(List<?> source, List<?> values) {
        if (source == null || source.isEmpty()) {
            ArrayList data = new ArrayList();
            for (Object value : values) {
                data.add(value);
            }
            return data;
        }
        return source;
    }

    protected List<String> collectUserAuthInfo() {
        ArrayList<String> entities = new ArrayList<String>();
        entities.add(this.identityProvider.getName());
        entities.addAll(CommonUtils.getAuthenticatedUserRoles((IdentityProvider)this.identityProvider));
        entities.add("_public_");
        return entities;
    }

    protected <T> Collection<T> applyPagination(List<T> input, QueryContext queryContext) {
        if (queryContext != null) {
            int start = queryContext.getOffset();
            int end = start + queryContext.getCount();
            if (input.size() < start) {
                return new ArrayList();
            }
            if (input.size() >= end) {
                return Collections.unmodifiableCollection(new ArrayList<T>(input.subList(start, end)));
            }
            if (input.size() < end) {
                return Collections.unmodifiableCollection(new ArrayList<T>(input.subList(start, input.size())));
            }
        }
        return Collections.unmodifiableCollection(input);
    }

    protected List<Integer> resolveCaseStatuses(List<CaseStatus> caseStatusesList) {
        return caseStatusesList != null ? caseStatusesList.stream().map(event -> event.getId()).collect(Collectors.toList()) : null;
    }

    public Collection<CaseFileItem> getCaseInstanceDataItems(String caseId, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("caseId", caseId);
        params.put("entities", this.collectUserAuthInfo());
        this.applyQueryContext(params, queryContext);
        List caseFileItems = (List)this.commandService.execute((Command)new QueryNameCommand("getCaseInstanceDataItems", params));
        return caseFileItems;
    }

    public Collection<CaseFileItem> getCaseInstanceDataItemsByName(String caseId, List<String> names, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("caseId", caseId);
        params.put("itemNames", names);
        params.put("entities", this.collectUserAuthInfo());
        this.applyQueryContext(params, queryContext);
        List caseFileItems = (List)this.commandService.execute((Command)new QueryNameCommand("getCaseInstanceDataItemsByName", params));
        return caseFileItems;
    }

    public Collection<CaseFileItem> getCaseInstanceDataItemsByType(String caseId, List<String> types, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("caseId", caseId);
        params.put("itemTypes", types);
        params.put("entities", this.collectUserAuthInfo());
        this.applyQueryContext(params, queryContext);
        List caseFileItems = (List)this.commandService.execute((Command)new QueryNameCommand("getCaseInstanceDataItemsByType", params));
        return caseFileItems;
    }

    private Collection<CaseInstance> fillCaseFiles(Collection<CaseInstance> caseInstances, boolean withData) {
        if (withData) {
            for (CaseInstance caseInstance : caseInstances) {
                caseInstance.setCaseFile(this.caseService.getCaseFileInstance(caseInstance.getCaseId()));
            }
        }
        return caseInstances;
    }
}

