/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.drools.core.command.SingleSessionCommandService;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.event.AbstractEventSupport;
import org.drools.core.time.TimerService;
import org.drools.persistence.api.OrderedTransactionSynchronization;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionManagerHelper;
import org.drools.persistence.api.TransactionSynchronization;
import org.jbpm.process.core.timer.TimerServiceRegistry;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.RuntimeEngineImpl;
import org.jbpm.runtime.manager.impl.RuntimeEngineInitlializer;
import org.jbpm.runtime.manager.impl.factory.LocalTaskServiceFactory;
import org.jbpm.runtime.manager.impl.mapper.EnvironmentAwareProcessInstanceContext;
import org.jbpm.runtime.manager.impl.mapper.InMemoryMapper;
import org.jbpm.runtime.manager.impl.mapper.InternalMapper;
import org.jbpm.runtime.manager.impl.mapper.JPAMapper;
import org.jbpm.runtime.manager.impl.tx.DisposeSessionTransactionSynchronization;
import org.jbpm.services.task.impl.TaskContentRegistry;
import org.jbpm.services.task.impl.command.CommandBasedTaskService;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.TaskService;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.runtime.manager.Disposable;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.Mapper;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.runtime.manager.SessionFactory;
import org.kie.internal.runtime.manager.TaskServiceFactory;
import org.kie.internal.runtime.manager.context.CaseContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.internal.task.api.InternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerCaseRuntimeManager
extends AbstractRuntimeManager {
    private static final Logger logger = LoggerFactory.getLogger(PerCaseRuntimeManager.class);
    private boolean useLocking = Boolean.parseBoolean(System.getProperty("org.jbpm.runtime.manager.pc.lock", "true"));
    private SessionFactory factory;
    private TaskServiceFactory taskServiceFactory;
    private static ThreadLocal<Map<Object, RuntimeEngine>> local = new ThreadLocal();
    private Mapper mapper;
    private AbstractEventSupport<? extends EventListener> caseEventSupport;

    public PerCaseRuntimeManager(org.kie.api.runtime.manager.RuntimeEnvironment environment, SessionFactory factory, TaskServiceFactory taskServiceFactory, String identifier) {
        super(environment, identifier);
        this.factory = factory;
        this.taskServiceFactory = taskServiceFactory;
        this.mapper = ((RuntimeEnvironment)environment).getMapper();
        this.registry.register((RuntimeManager)this);
    }

    public RuntimeEngine getRuntimeEngine(Context<?> context) {
        RuntimeEngine localRuntime;
        if (this.isClosed()) {
            throw new IllegalStateException("Runtime manager " + this.identifier + " is already closed");
        }
        RuntimeEngineImpl runtime = null;
        Object contextId = context.getContextId();
        if (!(context instanceof ProcessInstanceIdContext) && !(context instanceof CaseContext)) {
            logger.warn("ProcessInstanceIdContext or CaseContext shall be used when interacting with PerCase runtime manager");
        }
        if ((localRuntime = this.findLocalRuntime(contextId)) != null) {
            logger.debug("Runtime engine found in local {} with context {}", (Object)localRuntime, contextId);
            return localRuntime;
        }
        Long ksessionId = this.mapper.findMapping(context, this.getIdentifier());
        if (ksessionId == null && this.mapper instanceof InternalMapper) {
            logger.debug("PerCaseRuntimeManager KieSessionId not found, falling back for context {} and owner {}", context.getContextId(), (Object)this.getIdentifier());
            ksessionId = ((InternalMapper)this.mapper).findLogMapping(context, this.identifier);
        }
        logger.debug("PerCaseRuntimeManager KieSessionId {} found for context {} and owner {}", new Object[]{ksessionId, context.getContextId(), this.getIdentifier()});
        if (this.engineInitEager) {
            InternalTaskService internalTaskService = this.newTaskService(this.taskServiceFactory);
            runtime = new RuntimeEngineImpl(context, (TaskService)internalTaskService);
            runtime.setManager((RuntimeManager)this);
            this.configureRuntimeOnTaskService(internalTaskService, (RuntimeEngine)runtime);
            KieSession ksession = this.initPerCaseKSession(ksessionId, context, this, (RuntimeEngine)runtime);
            ksessionId = ksession.getIdentifier();
        } else {
            runtime = new RuntimeEngineImpl(context, new PerCaseInitializer(ksessionId));
            runtime.setManager((RuntimeManager)this);
        }
        String caseId = null;
        Long processInstanceId = null;
        if (context instanceof CaseContext) {
            caseId = (String)contextId;
        } else if (context instanceof ProcessInstanceIdContext) {
            processInstanceId = (Long)contextId;
        }
        this.createLockOnGetEngine(ksessionId, (RuntimeEngine)runtime);
        this.saveLocalRuntime(caseId, processInstanceId, (RuntimeEngine)runtime);
        return runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KieSession initPerCaseKSession(Long kieSessionIdMapped, Context<?> context, InternalRuntimeManager manager, RuntimeEngine engine) {
        Object contextId = context.getContextId();
        if (contextId == null) {
            contextId = manager.getIdentifier();
        }
        KieSession ksession = null;
        Long ksessionId = kieSessionIdMapped;
        InternalRuntimeManager internalRuntimeManager = manager;
        synchronized (internalRuntimeManager) {
            if (ksessionId == null) {
                ksession = this.factory.newKieSession();
                ksessionId = ksession.getIdentifier();
                if (context instanceof CaseContext) {
                    ksession.execute((Command)new SaveMappingCommand(this.mapper, context, ksessionId, manager.getIdentifier()));
                }
                logger.debug("Creating KieSessionId {} found for context {} and owner {}", new Object[]{ksessionId, context, this.getIdentifier()});
            } else {
                ksession = this.factory.findKieSessionById(ksessionId);
                logger.debug("Found KieSessionId {} for context {} and owner {}", new Object[]{ksessionId, context, this.getIdentifier()});
            }
        }
        ((RuntimeEngineImpl)engine).internalSetKieSession(ksession);
        this.registerItems(engine);
        this.attachManager(engine);
        this.registerDisposeCallback(engine, (TransactionSynchronization)new DisposeSessionTransactionSynchronization((RuntimeManager)manager, engine), ksession.getEnvironment());
        ksession.addEventListener((ProcessEventListener)new MaintainMappingListener(ksessionId, engine, manager.getIdentifier(), contextId.toString()));
        if (context instanceof CaseContext) {
            ksession.getEnvironment().set("CaseId", context.getContextId());
        } else {
            Object contexts = this.mapper.findContextId(Long.valueOf(ksession.getIdentifier()), manager.getIdentifier());
            if (contexts instanceof Collection) {
                KieSession finalKieSession = ksession;
                ((Collection)contexts).forEach(o -> {
                    try {
                        this.saveLocalRuntime(null, Long.parseLong(o.toString()), engine);
                    }
                    catch (NumberFormatException e) {
                        this.saveLocalRuntime(o.toString(), null, engine);
                        finalKieSession.getEnvironment().set("CaseId", (Object)o.toString());
                    }
                });
            }
        }
        return ksession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalEvent(String type, Object event) {
        RuntimeEngine runtimeEngine = this.getRuntimeEngine((Context<?>)ProcessInstanceIdContext.get());
        try {
            runtimeEngine.getKieSession().signalEvent(type, event);
        }
        finally {
            if (this.canDispose(runtimeEngine)) {
                this.disposeRuntimeEngine(runtimeEngine);
            }
        }
        List<String> processInstances = ((InternalMapper)this.mapper).findContextIdForEvent(type, this.getIdentifier());
        for (String piId : processInstances) {
            runtimeEngine = this.getRuntimeEngine((Context<?>)ProcessInstanceIdContext.get((Long)Long.parseLong(piId)));
            try {
                runtimeEngine.getKieSession().signalEvent(type, event);
            }
            finally {
                if (!this.canDispose(runtimeEngine)) continue;
                this.disposeRuntimeEngine(runtimeEngine);
            }
        }
        Map<Object, RuntimeEngine> currentlyActive = local.get();
        if (currentlyActive != null && !currentlyActive.isEmpty()) {
            HashSet<RuntimeEngine> activeEngines = new HashSet<RuntimeEngine>(currentlyActive.values());
            for (RuntimeEngine engine : activeEngines) {
                Context<?> context = ((RuntimeEngineImpl)engine).getContext();
                if (context == null || !(context instanceof ProcessInstanceIdContext) || ((ProcessInstanceIdContext)context).getContextId() == null) continue;
                engine.getKieSession().signalEvent(type, event, ((ProcessInstanceIdContext)context).getContextId().longValue());
            }
        }
    }

    public void validate(KieSession ksession, Context<?> context) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Runtime manager " + this.identifier + " is already closed");
        }
        if (context == null || context.getContextId() == null) {
            return;
        }
        Long ksessionId = this.mapper.findMapping(context, this.identifier);
        if (ksessionId != null && ksession.getIdentifier() != ksessionId.longValue()) {
            throw new IllegalStateException("Invalid session was used for this context " + context);
        }
    }

    public void disposeRuntimeEngine(RuntimeEngine runtime) {
        if (this.isClosed()) {
            logger.warn("Runtime manager {} is already closed", (Object)this.identifier);
            return;
        }
        Long ksessionId = ((RuntimeEngineImpl)runtime).getLazyKieSessionId();
        logger.debug("Trying to dispose for KieSessionId {} (Kie session id cannot be null at this point)", (Object)ksessionId);
        try {
            if (this.canDispose(runtime)) {
                this.removeLocalRuntime(runtime);
                logger.debug("About to release and clean runtime engine {}", (Object)runtime);
                this.releaseAndCleanLock(ksessionId, runtime);
                if (runtime instanceof Disposable) {
                    if (this.mapper instanceof InMemoryMapper && ((InMemoryMapper)this.mapper).hasContext(ksessionId)) {
                        return;
                    }
                    logger.debug("Calling dispose engine {}", (Object)runtime);
                    ((Disposable)runtime).dispose();
                }
                if (ksessionId != null) {
                    TimerService timerService = TimerServiceRegistry.getInstance().get(this.getIdentifier() + "-timerServiceId");
                    if (timerService != null) {
                        if (timerService instanceof GlobalTimerService) {
                            logger.debug("About to clear timer job instances for engine {}", (Object)runtime);
                            ((GlobalTimerService)timerService).clearTimerJobInstances(ksessionId.longValue());
                        }
                    } else {
                        logger.debug("Not timer service found for engine {}. Cannot clean up timer jobs", (Object)runtime);
                    }
                }
            } else {
                logger.debug("Cannot dispose the engine {}", (Object)runtime);
            }
        }
        catch (Exception e) {
            this.releaseAndCleanLock(ksessionId, runtime);
            this.removeLocalRuntime(runtime);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void softDispose(RuntimeEngine runtimeEngine) {
        super.softDispose(runtimeEngine);
        this.removeLocalRuntime(runtimeEngine);
    }

    @Override
    public void close() {
        try {
            if (!(this.taskServiceFactory instanceof LocalTaskServiceFactory)) {
                this.removeRuntimeFromTaskService();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
        this.factory.close();
    }

    public boolean validate(Long ksessionId, Long processInstanceId) {
        Long mapped = this.mapper.findMapping((Context)ProcessInstanceIdContext.get((Long)processInstanceId), this.identifier);
        return Objects.equals(mapped, ksessionId);
    }

    @Override
    public SessionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(SessionFactory factory) {
        this.factory = factory;
    }

    public TaskServiceFactory getTaskServiceFactory() {
        return this.taskServiceFactory;
    }

    public void setTaskServiceFactory(TaskServiceFactory taskServiceFactory) {
        this.taskServiceFactory = taskServiceFactory;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    protected RuntimeEngine findLocalRuntime(Object caseId) {
        if (caseId == null) {
            return null;
        }
        Map<Object, RuntimeEngine> map = local.get();
        if (map == null) {
            return null;
        }
        RuntimeEngine engine = map.get(caseId);
        if (engine != null && ((RuntimeEngineImpl)engine).isDisposed()) {
            map.remove(caseId);
            return null;
        }
        return engine;
    }

    protected void saveLocalRuntime(Object caseId, Object processInstanceId, RuntimeEngine runtime) {
        Map<Object, RuntimeEngine> map = local.get();
        if (map == null) {
            map = new HashMap<Object, RuntimeEngine>();
            local.set(map);
        }
        if (caseId != null) {
            map.put(caseId, runtime);
        }
        if (processInstanceId != null) {
            map.put(processInstanceId, runtime);
        }
    }

    protected void removeLocalRuntime(RuntimeEngine runtime) {
        Map<Object, RuntimeEngine> map = local.get();
        ArrayList<Object> keyToRemoves = new ArrayList<Object>();
        if (map != null) {
            for (Map.Entry<Object, RuntimeEngine> entry : map.entrySet()) {
                if (!runtime.equals(entry.getValue())) continue;
                keyToRemoves.add(entry.getKey());
            }
            for (Map.Entry<Object, Object> entry : keyToRemoves) {
                map.remove(entry);
            }
        }
    }

    protected void removeLocalRuntime(RuntimeEngine runtime, Long processInstanceId) {
        Map<Object, RuntimeEngine> map = local.get();
        ArrayList<Object> keyToRemoves = new ArrayList<Object>();
        if (map != null) {
            for (Map.Entry<Object, RuntimeEngine> entry : map.entrySet()) {
                if (!processInstanceId.equals(entry.getKey())) continue;
                keyToRemoves.add(entry.getKey());
            }
            for (Map.Entry<Object, Object> entry : keyToRemoves) {
                map.remove(entry);
            }
        }
    }

    @Override
    public void init() {
        super.init();
        TaskContentRegistry.get().addMarshallerContext(this.getIdentifier(), new ContentMarshallerContext(this.environment.getEnvironment(), this.environment.getClassLoader()));
        boolean owner = false;
        TransactionManager tm = null;
        if (this.environment.usePersistence()) {
            tm = this.getTransactionManagerInternal(this.environment.getEnvironment());
            owner = tm.begin();
        }
        try {
            KieSession initialKsession = this.factory.newKieSession();
            initialKsession.execute((Command)new ExecutableCommand<Void>(){
                private static final long serialVersionUID = 1L;

                public Void execute(org.kie.api.runtime.Context context) {
                    KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
                    ((InternalKnowledgeRuntime)ksession).getProcessRuntime();
                    return null;
                }
            });
            this.factory.onDispose(Long.valueOf(initialKsession.getIdentifier()));
            initialKsession.execute((Command)new DestroyKSessionCommand(initialKsession, this));
            if (!"false".equalsIgnoreCase(System.getProperty("org.jbpm.rm.init.timer")) && this.mapper instanceof JPAMapper) {
                List<Long> ksessionsToInit = ((JPAMapper)this.mapper).findKSessionToInit(this.identifier);
                for (Long id : ksessionsToInit) {
                    initialKsession = this.factory.findKieSessionById(id);
                    initialKsession.execute((Command)new DisposeKSessionCommand(initialKsession, this));
                }
            }
            if (tm != null) {
                tm.commit(owner);
            }
        }
        catch (Exception e) {
            if (tm != null) {
                tm.rollback(owner);
            }
            throw new RuntimeException("Exception while initializing runtime manager " + this.identifier, e);
        }
    }

    @Override
    public void activate() {
        super.activate();
        KieSession initialKsession = this.factory.newKieSession();
        initialKsession.execute((Command)new DestroyKSessionCommand(initialKsession, this));
    }

    @Override
    public void deactivate() {
        super.deactivate();
    }

    public void destroyCase(CaseContext caseContext) {
        KieSession kieSession = null;
        RuntimeEngine localRuntime = this.findLocalRuntime(caseContext.getContextId());
        if (localRuntime != null) {
            kieSession = localRuntime.getKieSession();
        } else {
            Long ksessionId = this.mapper.findMapping((Context)caseContext, this.identifier);
            if (ksessionId != null) {
                kieSession = this.factory.findKieSessionById(ksessionId);
            }
        }
        this.factory.onDispose(Long.valueOf(kieSession.getIdentifier()));
        ArrayList<Object> cmds = new ArrayList<Object>();
        RemoveMappingCommand removeMapping = new RemoveMappingCommand(this.mapper, (Context<?>)caseContext, this.getIdentifier());
        cmds.add(removeMapping);
        DestroyKSessionCommand destroy = new DestroyKSessionCommand(kieSession, this);
        cmds.add(destroy);
        BatchExecutionCommandImpl batchCmd = new BatchExecutionCommandImpl(cmds);
        kieSession.execute((Command)batchCmd);
    }

    public AbstractEventSupport<? extends EventListener> getCaseEventSupport() {
        return this.caseEventSupport;
    }

    public void setCaseEventSupport(AbstractEventSupport<? extends EventListener> caseEventSupport) {
        this.caseEventSupport = caseEventSupport;
    }

    @Override
    protected boolean isUseLocking() {
        return this.useLocking;
    }

    @Override
    protected void registerItems(RuntimeEngine runtime) {
        super.registerItems(runtime);
        if (this.getCaseEventSupport() != null) {
            List eventListener = this.getCaseEventSupport().getEventListeners();
            for (EventListener listener : eventListener) {
                if (!(listener instanceof ProcessEventListener)) continue;
                runtime.getKieSession().addEventListener((ProcessEventListener)listener);
            }
        }
    }

    private static class RemoveMappingCommand
    implements ExecutableCommand<Void> {
        private static final long serialVersionUID = 1L;
        private Mapper mapper;
        private Context<?> caseContext;
        private String ownerId;

        public RemoveMappingCommand(Mapper mapper, Context<?> caseContext, String ownerId) {
            this.mapper = mapper;
            this.caseContext = caseContext;
            this.ownerId = ownerId;
        }

        public Void execute(org.kie.api.runtime.Context context) {
            this.mapper.removeMapping(this.caseContext, this.ownerId);
            return null;
        }
    }

    private static class SaveMappingCommand
    implements ExecutableCommand<Void> {
        private static final long serialVersionUID = 1L;
        private Mapper mapper;
        private Context<?> caseContext;
        private Long ksessionId;
        private String ownerId;

        public SaveMappingCommand(Mapper mapper, Context<?> caseContext, Long ksessionId, String ownerId) {
            this.mapper = mapper;
            this.caseContext = caseContext;
            this.ksessionId = ksessionId;
            this.ownerId = ownerId;
        }

        public Void execute(org.kie.api.runtime.Context context) {
            this.mapper.saveMapping(this.caseContext, this.ksessionId, this.ownerId);
            return null;
        }
    }

    private static class DisposeKSessionCommand
    implements ExecutableCommand<Void> {
        private static final long serialVersionUID = 1L;
        private KieSession initialKsession;
        private AbstractRuntimeManager manager;

        public DisposeKSessionCommand(KieSession initialKsession, AbstractRuntimeManager manager) {
            this.initialKsession = initialKsession;
            this.manager = manager;
        }

        public Void execute(org.kie.api.runtime.Context context) {
            if (this.manager.hasEnvironmentEntry("IS_JTA_TRANSACTION", false)) {
                this.initialKsession.dispose();
                return null;
            }
            TransactionManager tm = (TransactionManager)this.initialKsession.getEnvironment().get("org.kie.transaction.TransactionManager");
            if (tm != null && tm.getStatus() != 3 && tm.getStatus() != 1 && tm.getStatus() != 0) {
                TransactionManagerHelper.registerTransactionSyncInContainer((TransactionManager)tm, (OrderedTransactionSynchronization)new OrderedTransactionSynchronization(5, "PPIRM-" + this.initialKsession.getIdentifier()){

                    public void beforeCompletion() {
                    }

                    public void afterCompletion(int arg0) {
                        initialKsession.dispose();
                    }
                });
            } else {
                this.initialKsession.dispose();
            }
            return null;
        }
    }

    private static class DestroyKSessionCommand
    implements ExecutableCommand<Void> {
        private static final long serialVersionUID = 1L;
        private KieSession initialKsession;
        private AbstractRuntimeManager manager;

        public DestroyKSessionCommand(KieSession initialKsession, AbstractRuntimeManager manager) {
            this.initialKsession = initialKsession;
            this.manager = manager;
        }

        public Void execute(org.kie.api.runtime.Context context) {
            TransactionManager tm = (TransactionManager)this.initialKsession.getEnvironment().get("org.kie.transaction.TransactionManager");
            if (this.manager.hasEnvironmentEntry("IS_JTA_TRANSACTION", false)) {
                if (this.initialKsession instanceof CommandBasedStatefulKnowledgeSession) {
                    ExecutableRunner commandService = ((CommandBasedStatefulKnowledgeSession)this.initialKsession).getRunner();
                    ((SingleSessionCommandService)commandService).destroy();
                } else {
                    ((KieSession)((RegistryContext)context).lookup(KieSession.class)).destroy();
                }
                return null;
            }
            if (tm != null && tm.getStatus() != 3 && tm.getStatus() != 1 && tm.getStatus() != 0) {
                TransactionManagerHelper.registerTransactionSyncInContainer((TransactionManager)tm, (OrderedTransactionSynchronization)new OrderedTransactionSynchronization(5, "PCRM-" + this.initialKsession.getIdentifier()){

                    public void beforeCompletion() {
                        if (initialKsession instanceof CommandBasedStatefulKnowledgeSession) {
                            ExecutableRunner commandService = ((CommandBasedStatefulKnowledgeSession)initialKsession).getRunner();
                            ((SingleSessionCommandService)commandService).destroy();
                        }
                    }

                    public void afterCompletion(int arg0) {
                        initialKsession.dispose();
                    }
                });
            } else {
                this.initialKsession.destroy();
            }
            return null;
        }
    }

    private class MaintainMappingListener
    extends DefaultProcessEventListener {
        private Long ksessionId;
        private RuntimeEngine runtime;
        private String managerId;
        private String caseId;

        MaintainMappingListener(Long ksessionId, RuntimeEngine runtime, String managerId, String caseId) {
            this.ksessionId = ksessionId;
            this.runtime = runtime;
            this.managerId = managerId;
            this.caseId = caseId;
        }

        public void afterProcessCompleted(ProcessCompletedEvent event) {
            logger.debug("Removing persistence mapping for kieSessionId {} runtime engine {} manager {} and case id {}", new Object[]{this.ksessionId, this.runtime, this.managerId, this.caseId});
            PerCaseRuntimeManager.this.mapper.removeMapping((Context)new EnvironmentAwareProcessInstanceContext(event.getKieRuntime().getEnvironment(), event.getProcessInstance().getId()), this.managerId);
            PerCaseRuntimeManager.this.removeLocalRuntime(this.runtime, event.getProcessInstance().getId());
        }

        public void beforeProcessStarted(ProcessStartedEvent event) {
            logger.debug("Saving persistence mapping for kieSessionId {} runtime engine {} manager {} and case id {}", new Object[]{this.ksessionId, this.runtime, this.managerId, this.caseId});
            PerCaseRuntimeManager.this.mapper.saveMapping((Context)new EnvironmentAwareProcessInstanceContext(event.getKieRuntime().getEnvironment(), event.getProcessInstance().getId()), this.ksessionId, this.managerId);
            PerCaseRuntimeManager.this.saveLocalRuntime(this.caseId, event.getProcessInstance().getId(), this.runtime);
            ((RuntimeEngineImpl)this.runtime).setContext((Context<?>)ProcessInstanceIdContext.get((Long)event.getProcessInstance().getId()));
        }
    }

    private class PerCaseInitializer
    implements RuntimeEngineInitlializer {
        private Long kieSessionId;

        public PerCaseInitializer(Long kieSessionId) {
            this.kieSessionId = kieSessionId;
        }

        @Override
        public Long getKieSessionId() {
            return this.kieSessionId;
        }

        @Override
        public KieSession initKieSession(Context<?> context, InternalRuntimeManager manager, RuntimeEngine engine) {
            RuntimeEngine localRuntime;
            Object contextId = context.getContextId();
            if (contextId == null) {
                contextId = manager.getIdentifier();
            }
            if ((localRuntime = ((PerCaseRuntimeManager)manager).findLocalRuntime(contextId)) != null && engine != null && ((RuntimeEngineImpl)engine).getKieSessionId() != null) {
                return localRuntime.getKieSession();
            }
            return PerCaseRuntimeManager.this.initPerCaseKSession(this.kieSessionId, context, manager, engine);
        }

        @Override
        public TaskService initTaskService(Context<?> context, InternalRuntimeManager manager, RuntimeEngine engine) {
            InternalTaskService internalTaskService = PerCaseRuntimeManager.this.newTaskService(PerCaseRuntimeManager.this.taskServiceFactory);
            if (internalTaskService != null) {
                PerCaseRuntimeManager.this.registerDisposeCallback(engine, (TransactionSynchronization)new DisposeSessionTransactionSynchronization((RuntimeManager)manager, engine), ((CommandBasedTaskService)internalTaskService).getEnvironment());
                PerCaseRuntimeManager.this.configureRuntimeOnTaskService(internalTaskService, engine);
            }
            return internalTaskService;
        }
    }
}

