/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.cmmn.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.casemgmt.cmmn.xml.AbstractCaseNodeHandler;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ProcessTaskHandler
extends AbstractCaseNodeHandler {
    private static final Logger logger = LoggerFactory.getLogger(ProcessTaskHandler.class);

    @Override
    protected Node createNode(Attributes attrs) {
        return new SubProcessNode();
    }

    public Class generateNodeFor() {
        return SubProcessNode.class;
    }

    @Override
    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        SubProcessNode subProcessNode = (SubProcessNode)node;
        String processId = element.getAttribute("processRef");
        String isBlocking = element.getAttribute("isBlocking");
        if (isBlocking == null || isBlocking.isEmpty()) {
            isBlocking = "true";
        }
        subProcessNode.setProcessId(processId);
        subProcessNode.setWaitForCompletion(Boolean.parseBoolean(isBlocking));
        subProcessNode.setIndependent(false);
        HashMap<String, String> inputs = new HashMap<String, String>();
        HashMap<String, String> outputs = new HashMap<String, String>();
        HashMap<String, String> inputTypes = new HashMap<String, String>();
        HashMap<String, String> outputTypes = new HashMap<String, String>();
        this.loadDataInputsAndOutputs(element, inputs, outputs, inputTypes, outputTypes, parser);
        subProcessNode.setMetaData("DataInputs", inputTypes);
        subProcessNode.setMetaData("DataOutputs", outputTypes);
        subProcessNode.setMetaData("customAbortParent", (Object)"false");
        for (Map.Entry entry : inputs.entrySet()) {
            subProcessNode.addInAssociation(new DataAssociation((String)entry.getValue(), (String)entry.getKey(), Collections.emptyList(), null));
        }
        for (Map.Entry entry : outputs.entrySet()) {
            subProcessNode.addOutAssociation(new DataAssociation((String)entry.getKey(), (String)entry.getValue(), Collections.emptyList(), null));
        }
    }
}

